/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entity.properties;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum MovementType implements StringRepresentable
{
    WANDER(0),
    FOLLOW_OWNER(1),
    STANDSTILL(2);

    public static final StringRepresentable.EnumCodec<MovementType> CODEC;
    private static final IntFunction<MovementType> BY_ID;
    public static final StreamCodec<ByteBuf, MovementType> STREAM_CODEC;
    private final int id;

    private MovementType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        CODEC = StringRepresentable.fromEnum(MovementType::values);
        BY_ID = ByIdMap.continuous(MovementType::getId, (Object[])MovementType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, MovementType::getId);
    }
}

