/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entity.goal;

import java.util.EnumSet;
import net.chococraft.common.entity.AbstractChocobo;
import net.chococraft.registry.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ChocoboHealInPenGoal
extends Goal {
    private final AbstractChocobo chocobo;

    public ChocoboHealInPenGoal(AbstractChocobo chocobo) {
        this.chocobo = chocobo;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (this.chocobo.level().getGameTime() % 40L == 0L && this.chocobo.getHealth() != this.chocobo.getMaxHealth()) {
            return this.chocobo.level().getBlockState(this.chocobo.blockPosition()).is((Block)ModRegistry.STRAW.get());
        }
        return false;
    }

    public void start() {
        BlockPos pos = this.chocobo.blockPosition();
        Iterable positions = BlockPos.betweenClosed((BlockPos)pos.offset(-5, 0, -5), (BlockPos)pos.offset(5, 0, 5));
        for (BlockPos position : positions) {
            BlockState state = this.chocobo.level().getBlockState(position);
            if (!state.is(Blocks.WATER_CAULDRON) || (Integer)state.getValue((Property)BlockStateProperties.LEVEL_CAULDRON) != 3) continue;
            this.chocobo.heal(this.chocobo.getRandom().nextInt(3) + 1);
        }
    }
}

