/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Rail_Bridge
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    protected static final VoxelShape OCCLUSION = Block.box((double)0.0, (double)0.1, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public Rail_Bridge(BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        return OCCLUSION;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, FACING});
    }

    public int getSignal(BlockState state, BlockGetter reader, BlockPos pos, Direction dir) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return 10;
        }
        return 0;
    }

    public boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED) == true;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item item = itemstack.getItem();
        Boolean power = (Boolean)state.getValue((Property)POWERED);
        if (power.booleanValue() && item == Items.AIR) {
            state = (BlockState)state.cycle((Property)POWERED);
            level.setBlock(pos, state, 2);
            Rail_Bridge.dropTorch(level, pos);
            return ItemInteractionResult.CONSUME;
        }
        if (item == Items.REDSTONE_TORCH && !power.booleanValue()) {
            state = (BlockState)state.cycle((Property)POWERED);
            level.setBlock(pos, state, 2);
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            return ItemInteractionResult.CONSUME;
        }
        if (!power.booleanValue() && item != Items.REDSTONE_TORCH) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static void dropTorch(Level level, BlockPos pos) {
        Rail_Bridge.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.REDSTONE_TORCH, 1));
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player user) {
        Boolean i = (Boolean)state.getValue((Property)POWERED);
        if (!level.isClientSide && i.booleanValue()) {
            Rail_Bridge.dropTorch(level, pos);
        }
        return super.playerWillDestroy(level, pos, state, user);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)contx.getHorizontalDirection().getClockWise());
    }

    public void placeAt(Level level, BlockPos pos, int num) {
        level.setBlock(pos, this.defaultBlockState(), num);
    }
}

