/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut;

import appeng.integration.modules.curios.CuriosIntegration;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.menu.locator.MenuLocators;
import de.mari_023.ae2wtlib.AE2wtlibComponents;
import de.mari_023.ae2wtlib.TextConstants;
import de.mari_023.ae2wtlib.networking.UpdateWUTPackage;
import de.mari_023.ae2wtlib.wut.ItemWUT;
import de.mari_023.ae2wtlib.wut.WTDefinition;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class WUTHandler {
    public static void setCurrentTerminal(Player player, ItemMenuHostLocator locator, ItemStack itemStack, WTDefinition terminal) {
        if (!(itemStack.getItem() instanceof ItemWUT)) {
            return;
        }
        if (!WUTHandler.hasTerminal(itemStack, terminal)) {
            return;
        }
        itemStack.set(AE2wtlibComponents.CURRENT_TERMINAL, (Object)terminal);
        WUTHandler.updateClientTerminal((ServerPlayer)player, locator, itemStack);
    }

    @Contract(pure=true)
    public static boolean hasTerminal(ItemStack stack, WTDefinition terminal) {
        if (stack.isEmpty()) {
            return false;
        }
        if (stack.getItem() instanceof ItemWUT) {
            return stack.get(terminal.componentType()) != null;
        }
        return stack.getItem().equals((Object)terminal.item());
    }

    public static void cycle(Player player, ItemMenuHostLocator locator, ItemStack itemStack, boolean isHandlingRightClick) {
        itemStack.set(AE2wtlibComponents.CURRENT_TERMINAL, (Object)WUTHandler.nextTerminal(itemStack, isHandlingRightClick));
        WUTHandler.updateClientTerminal((ServerPlayer)player, locator, itemStack);
    }

    @Contract(pure=true)
    public static WTDefinition nextTerminal(ItemStack stack, boolean reverse) {
        int i;
        WTDefinition nextTerminal = WTDefinition.of(stack);
        List<WTDefinition> terminals = WTDefinition.wirelessTerminalList;
        do {
            if (reverse) {
                i = terminals.indexOf(nextTerminal) - 1;
                if (i != -1) continue;
                i = terminals.size() - 1;
                continue;
            }
            i = terminals.indexOf(nextTerminal) + 1;
            if (i != terminals.size()) continue;
            i = 0;
        } while (stack.get((nextTerminal = terminals.get(i)).componentType()) == null);
        return nextTerminal;
    }

    public static void updateClientTerminal(ServerPlayer player, ItemMenuHostLocator locator, ItemStack stack) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UpdateWUTPackage(locator, stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static boolean open(Player player, ItemMenuHostLocator locator, boolean returningFromSubmenu) {
        WTDefinition currentTerminal = WTDefinition.ofOrNull(locator.locateItem(player));
        if (currentTerminal == null) {
            player.displayClientMessage(TextConstants.TERMINAL_EMPTY, false);
            return false;
        }
        return currentTerminal.containerOpener().tryOpen(player, locator, returningFromSubmenu);
    }

    @Nullable
    public static ItemMenuHostLocator findTerminal(Player player, WTDefinition terminal) {
        int i;
        IItemHandler cap = (IItemHandler)player.getCapability(CuriosIntegration.ITEM_HANDLER);
        if (cap != null) {
            for (i = 0; i < cap.getSlots(); ++i) {
                if (!WUTHandler.hasTerminal(cap.getStackInSlot(i), terminal)) continue;
                return MenuLocators.forCurioSlot((int)i);
            }
        }
        for (i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!WUTHandler.hasTerminal(player.getInventory().getItem(i), terminal)) continue;
            return MenuLocators.forInventorySlot((int)i);
        }
        return null;
    }

    @Contract(pure=true)
    public static int getUpgradeCardCount() {
        int upgradeCards = 0;
        for (WTDefinition terminal : WTDefinition.wirelessTerminals()) {
            upgradeCards += terminal.upgradeCount();
        }
        return upgradeCards;
    }
}

