/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut;

import appeng.api.config.Actionable;
import appeng.api.features.HotkeyAction;
import appeng.hotkeys.HotkeyActions;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import de.mari_023.ae2wtlib.AE2wtlibComponents;
import de.mari_023.ae2wtlib.AE2wtlibItems;
import de.mari_023.ae2wtlib.TextConstants;
import de.mari_023.ae2wtlib.hotkeys.Ae2wtlibLocatingService;
import de.mari_023.ae2wtlib.terminal.Icon;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wut.AddTerminalEvent;
import de.mari_023.ae2wtlib.wut.WTDefinition;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class WTDefinitionBuilder {
    private final AddTerminalEvent event;
    private final String name;
    private final WTDefinition.WTMenuHostFactory wTMenuHostFactory;
    private final MenuType<?> menuType;
    private final ItemWT item;
    private final Icon icon;
    private String hotkeyName;
    @Nullable
    private DataComponentType<Unit> componentType;
    private String translationKey;
    private int upgradeCount;

    WTDefinitionBuilder(AddTerminalEvent event, String terminalName, WTDefinition.WTMenuHostFactory wTMenuHostFactory, MenuType<?> menuType, ItemWT item, Icon icon) {
        this.event = event;
        this.name = terminalName;
        this.wTMenuHostFactory = wTMenuHostFactory;
        this.menuType = menuType;
        this.item = item;
        this.hotkeyName = "wireless_" + terminalName + "_terminal";
        this.translationKey = "item.ae2wtlib.wireless_" + terminalName + "_terminal";
        this.upgradeCount = 2;
        this.icon = icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTerminal() {
        if (this.componentType == null) {
            this.componentType = AE2wtlibComponents.register("has_" + this.name + "_terminal", builder -> builder.persistent(Codec.EMPTY.codec()).networkSynchronized(NeoForgeStreamCodecs.enumCodec(Unit.class)));
        }
        if (WTDefinition.exists(this.name)) {
            throw new IllegalStateException("Trying to register terminal with name " + this.name + " but it already exists");
        }
        ItemStack wut = new ItemStack((ItemLike)AE2wtlibItems.UNIVERSAL_TERMINAL);
        wut.set(this.componentType, (Object)Unit.INSTANCE);
        AE2wtlibItems.UNIVERSAL_TERMINAL.injectAEPower(wut, AE2wtlibItems.UNIVERSAL_TERMINAL.getAEMaxPower(wut), Actionable.MODULATE);
        WTDefinition wtDefinition = new WTDefinition(this.name, this.item::tryOpen, this.wTMenuHostFactory, this.menuType, this.item, wut, TextConstants.formatTerminalName(this.translationKey), this.translationKey, this.hotkeyName, this.componentType, this.upgradeCount, this.icon);
        HotkeyActions.register((HotkeyAction)new Ae2wtlibLocatingService(wtDefinition), (String)this.hotkeyName);
        AddTerminalEvent addTerminalEvent = this.event;
        synchronized (addTerminalEvent) {
            WTDefinition.add(this.name, wtDefinition);
        }
    }

    @Contract(value="_ -> this")
    public WTDefinitionBuilder hotkeyName(String hotkeyName) {
        this.hotkeyName = hotkeyName;
        return this;
    }

    @Contract(value="_ -> this")
    public WTDefinitionBuilder translationKey(String translationKey) {
        this.translationKey = translationKey;
        return this;
    }

    @Contract(value="_ -> this")
    public WTDefinitionBuilder upgradeCount(int upgradeCount) {
        this.upgradeCount = upgradeCount;
        return this;
    }

    @Contract(value=" -> this")
    public WTDefinitionBuilder noUpgrades() {
        return this.upgradeCount(0);
    }
}

