/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut;

import appeng.menu.ISubMenu;
import appeng.menu.locator.ItemMenuHostLocator;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import de.mari_023.ae2wtlib.AE2wtlibComponents;
import de.mari_023.ae2wtlib.terminal.Icon;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.terminal.WTMenuHost;
import de.mari_023.ae2wtlib.wut.ItemWUT;
import io.netty.buffer.ByteBuf;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record WTDefinition(String terminalName, ContainerOpener containerOpener, WTMenuHostFactory wTMenuHostFactory, MenuType<?> menuType, ItemWT item, ItemStack universalTerminal, MutableComponent formattedName, String translationKey, String hotkeyName, DataComponentType<Unit> componentType, int upgradeCount, Icon icon) {
    private static final Map<String, WTDefinition> wirelessTerminals = new HashMap<String, WTDefinition>();
    static final List<WTDefinition> wirelessTerminalList = new ArrayList<WTDefinition>();
    public static final Codec<WTDefinition> CODEC = Codec.STRING.comapFlatMap(s -> {
        WTDefinition terminal = wirelessTerminals.get(s);
        if (terminal == null) {
            return DataResult.error(() -> "WTDefinition " + s + " does not exist");
        }
        return DataResult.success((Object)terminal);
    }, WTDefinition::terminalName);
    public static final StreamCodec<ByteBuf, WTDefinition> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(WTDefinition::of, WTDefinition::terminalName);

    static void add(String terminalName, WTDefinition definition) {
        wirelessTerminals.put(terminalName, definition);
        wirelessTerminalList.add(definition);
    }

    public static boolean exists(String terminalName) {
        return wirelessTerminals.containsKey(terminalName);
    }

    public static Collection<WTDefinition> wirelessTerminals() {
        return wirelessTerminals.values();
    }

    static WTDefinition of(String name) {
        return Objects.requireNonNull(wirelessTerminals.get(name));
    }

    public static WTDefinition of(ItemStack stack) {
        return Objects.requireNonNull(WTDefinition.ofOrNull(stack));
    }

    @Nullable
    public static WTDefinition ofOrNull(ItemStack stack) {
        Item item = stack.getItem();
        Objects.requireNonNull(item);
        Item item2 = item;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemWUT.class, ItemWT.class}, (Object)item2, n)) {
            case 0 -> {
                ItemWUT ignored = (ItemWUT)item2;
                WTDefinition currentTerminal = (WTDefinition)stack.get(AE2wtlibComponents.CURRENT_TERMINAL);
                if (currentTerminal != null) {
                    yield currentTerminal;
                }
                for (Map.Entry<String, WTDefinition> term : wirelessTerminals.entrySet()) {
                    if (stack.get(term.getValue().componentType()) == null) continue;
                    currentTerminal = term.getValue();
                    stack.set(AE2wtlibComponents.CURRENT_TERMINAL, (Object)currentTerminal);
                    yield currentTerminal;
                }
                yield null;
            }
            case 1 -> {
                ItemWT item = (ItemWT)item2;
                yield WTDefinition.ofOrNull(item);
            }
            default -> null;
        };
    }

    @Nullable
    private static WTDefinition ofOrNull(ItemWT item) {
        for (Map.Entry<String, WTDefinition> entry : wirelessTerminals.entrySet()) {
            if (!((Object)((Object)item)).equals((Object)entry.getValue().item())) continue;
            return entry.getValue();
        }
        return null;
    }

    @FunctionalInterface
    public static interface ContainerOpener {
        public boolean tryOpen(Player var1, ItemMenuHostLocator var2, boolean var3);
    }

    @FunctionalInterface
    public static interface WTMenuHostFactory {
        public WTMenuHost create(ItemWT var1, Player var2, ItemMenuHostLocator var3, BiConsumer<Player, ISubMenu> var4);
    }
}

