/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut;

import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.menu.locator.ItemMenuHostLocator;
import de.mari_023.ae2wtlib.TextConstants;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wut.WTDefinition;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemWUT
extends ItemWT {
    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (WTDefinition.ofOrNull(player.getItemInHand(hand)) == null) {
            if (!level.isClientSide()) {
                player.sendSystemMessage(TextConstants.TERMINAL_EMPTY);
            }
            return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)player.getItemInHand(hand));
        }
        return super.use(level, player, hand);
    }

    public double getChargeRate(ItemStack stack) {
        return 800.0 * (double)(this.countInstalledTerminals(stack) + 1 + this.getUpgrades(stack).getInstalledUpgrades((ItemLike)AEItems.ENERGY_CARD));
    }

    @Override
    public boolean open(Player player, ItemMenuHostLocator locator, boolean returningFromSubmenu) {
        return WUTHandler.open(player, locator, returningFromSubmenu);
    }

    @Override
    public MenuType<?> getMenuType(ItemMenuHostLocator locator, Player player) {
        return WTDefinition.of(locator.locateItem(player)).menuType();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advancedTooltips) {
        lines.add((Component)TextConstants.UNIVERSAL);
        for (WTDefinition terminal : WTDefinition.wirelessTerminals()) {
            if (stack.get(terminal.componentType()) == null) continue;
            lines.add((Component)terminal.formattedName());
        }
        super.appendHoverText(stack, context, lines, advancedTooltips);
    }

    public IUpgradeInventory getUpgrades(ItemStack stack) {
        return UpgradeInventories.forItem((ItemStack)stack, (int)(this.countInstalledTerminals(stack) * 2), this::onUpgradesChanged);
    }

    public void onUpgradesChanged(ItemStack stack, IUpgradeInventory upgrades) {
        this.setAEMaxPowerMultiplier(stack, this.countInstalledTerminals(stack) + Upgrades.getEnergyCardMultiplier((IUpgradeInventory)upgrades));
    }

    public int countInstalledTerminals(ItemStack stack) {
        int terminals = 0;
        for (WTDefinition terminal : WTDefinition.wirelessTerminals()) {
            if (stack.get(terminal.componentType()) == null) continue;
            ++terminals;
        }
        return terminals;
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int i, boolean bl) {
        for (WTDefinition terminal : WTDefinition.wirelessTerminals()) {
            if (itemStack.get(terminal.componentType()) == null) continue;
            terminal.item().inventoryTick(itemStack, level, entity, i, bl);
        }
    }

    public IConfigManager getConfigManager(Supplier<ItemStack> target) {
        return WTDefinition.of(target.get()).item().getConfigManager(target);
    }
}

