/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut;

import appeng.api.upgrades.IUpgradeableObject;
import appeng.client.Hotkey;
import appeng.client.Hotkeys;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.style.TerminalStyle;
import appeng.core.AEConfig;
import appeng.core.network.serverbound.HotkeyPacket;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import de.mari_023.ae2wtlib.AE2wtlibSlotSemantics;
import de.mari_023.ae2wtlib.TextConstants;
import de.mari_023.ae2wtlib.networking.CycleTerminalPacket;
import de.mari_023.ae2wtlib.terminal.IconButton;
import de.mari_023.ae2wtlib.terminal.ScrollingUpgradesPanel;
import de.mari_023.ae2wtlib.terminal.WTMenuHost;
import de.mari_023.ae2wtlib.wut.WTDefinition;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.UnknownNullability;

public interface IUniversalTerminalCapable {
    default public void cycleTerminal() {
        this.storeState();
        PacketDistributor.sendToServer((CustomPacketPayload)new CycleTerminalPacket(this.isHandlingRightClick()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public WTMenuHost getHost();

    public boolean isHandlingRightClick();

    public void storeState();

    default public boolean checkForTerminalKeys(int keyCode, int scanCode) {
        for (WTDefinition terminal : WTDefinition.wirelessTerminals()) {
            Hotkey hotkey = Hotkeys.getHotkeyMapping((String)terminal.hotkeyName());
            if (hotkey == null || !hotkey.mapping().matches(keyCode, scanCode)) continue;
            PacketDistributor.sendToServer((CustomPacketPayload)new HotkeyPacket(hotkey), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return false;
    }

    @Contract(value="-> new", pure=true)
    default public IconButton cycleTerminalButton() {
        WTDefinition next = WUTHandler.nextTerminal(this.getHost().getItemStack(), false);
        WTDefinition previous = WUTHandler.nextTerminal(this.getHost().getItemStack(), true);
        return IconButton.withAE2Background(btn -> this.cycleTerminal(), next.icon()).withTooltip(List.of(TextConstants.cycleNext(next), TextConstants.cyclePrevious(previous)));
    }

    default public ScrollingUpgradesPanel addUpgradePanel(WidgetContainer widgets, AEBaseMenu menu) {
        ArrayList<Slot> upgrades = new ArrayList<Slot>(menu.getSlots(AE2wtlibSlotSemantics.SINGULARITY));
        upgrades.addAll(menu.getSlots(SlotSemantics.UPGRADE));
        ScrollingUpgradesPanel panel = new ScrollingUpgradesPanel(upgrades, (IUpgradeableObject)this.getHost(), widgets, () -> this.getHost().getUpgrades());
        widgets.add("scrollingUpgrades", (ICompositeWidget)panel);
        return panel;
    }

    default public int getVisibleRows() {
        int availableHeight = this.getRectangle().height() - 2 * AEConfig.instance().getTerminalMargin();
        TerminalStyle style = Objects.requireNonNull(this.getStyle().getTerminalStyle());
        return AEConfig.instance().getTerminalStyle().getRows(style.getPossibleRows(availableHeight));
    }

    public @UnknownNullability ScreenStyle getStyle();

    public ScreenRectangle getRectangle();
}

