/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut;

import de.mari_023.ae2wtlib.terminal.Icon;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wut.WTDefinition;
import de.mari_023.ae2wtlib.wut.WTDefinitionBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class AddTerminalEvent {
    @Nullable
    private static List<Consumer<AddTerminalEvent>> HANDLERS = new ArrayList<Consumer<AddTerminalEvent>>();

    private AddTerminalEvent() {
    }

    public static synchronized void register(Consumer<AddTerminalEvent> handler) {
        if (HANDLERS == null) {
            throw new IllegalStateException("Cannot register terminal registration handler after terminal registration already happened");
        }
        HANDLERS.add(handler);
    }

    public static synchronized void run() {
        if (HANDLERS == null) {
            throw new IllegalStateException("Cannot run terminal registration handler twice");
        }
        AddTerminalEvent event = new AddTerminalEvent();
        HANDLERS.forEach(c -> c.accept(event));
        HANDLERS = null;
    }

    @Contract(pure=true)
    public static synchronized boolean didRun() {
        return HANDLERS == null;
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    public WTDefinitionBuilder builder(String terminalName, WTDefinition.WTMenuHostFactory WTMenuHostFactory2, MenuType<?> menuType, ItemWT item, Icon icon) {
        return new WTDefinitionBuilder(this, terminalName, WTMenuHostFactory2, menuType, item, icon);
    }
}

