/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct;

import appeng.client.gui.me.items.CraftingTermScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.menu.AEBaseMenu;
import appeng.menu.me.items.CraftingTermMenu;
import de.mari_023.ae2wtlib.TextConstants;
import de.mari_023.ae2wtlib.terminal.ArmorSlot;
import de.mari_023.ae2wtlib.terminal.Icon;
import de.mari_023.ae2wtlib.terminal.IconButton;
import de.mari_023.ae2wtlib.terminal.ScrollingUpgradesPanel;
import de.mari_023.ae2wtlib.terminal.WTMenuHost;
import de.mari_023.ae2wtlib.wct.PlayerEntityWidget;
import de.mari_023.ae2wtlib.wct.WCTMenu;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetMode;
import de.mari_023.ae2wtlib.wut.IUniversalTerminalCapable;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WCTScreen
extends CraftingTermScreen<WCTMenu>
implements IUniversalTerminalCapable {
    private final IconButton magnetCardToggleButton;
    private final IconButton magnetCardMenuButton;
    private final ScrollingUpgradesPanel upgradesPanel;

    public WCTScreen(WCTMenu container, Inventory playerInventory, Component title, ScreenStyle style) {
        super((CraftingTermMenu)container, playerInventory, title, style);
        if (((WCTMenu)this.getMenu()).isWUT()) {
            this.addToLeftToolbar(this.cycleTerminalButton());
        }
        this.magnetCardToggleButton = new IconButton(btn -> this.setMagnetMode(), Icon.MAGNET);
        this.widgets.add("magnetCardToggleButton", (AbstractWidget)this.magnetCardToggleButton);
        this.magnetCardMenuButton = new IconButton(btn -> ((WCTMenu)this.getMenu()).openMagnetMenu(), Icon.MAGNET_FILTER);
        this.widgets.add("magnetCardMenuButton", (AbstractWidget)this.magnetCardMenuButton);
        this.magnetCardMenuButton.setMessage(TextConstants.MAGNET_FILTER);
        IconButton trashButton = new IconButton(btn -> ((WCTMenu)this.getMenu()).openTrashMenu(), Icon.TRASH);
        this.widgets.add("trashButton", (AbstractWidget)trashButton);
        trashButton.setMessage((Component)TextConstants.TRASH);
        this.widgets.add("player", (AbstractWidget)new PlayerEntityWidget((LivingEntity)Objects.requireNonNull(Minecraft.getInstance().player)));
        this.upgradesPanel = this.addUpgradePanel(this.widgets, (AEBaseMenu)this.getMenu());
    }

    public void init() {
        super.init();
        this.upgradesPanel.setMaxRows(Math.max(2, this.getVisibleRows()));
    }

    private void setMagnetMode() {
        if (this.isHandlingRightClick()) {
            switch (((WCTMenu)this.getMenu()).getMagnetMode()) {
                case OFF: {
                    ((WCTMenu)this.getMenu()).setMagnetMode(MagnetMode.PICKUP_ME);
                    break;
                }
                case PICKUP_INVENTORY: {
                    ((WCTMenu)this.getMenu()).setMagnetMode(MagnetMode.OFF);
                    break;
                }
                case PICKUP_ME: {
                    ((WCTMenu)this.getMenu()).setMagnetMode(MagnetMode.PICKUP_INVENTORY);
                }
            }
            return;
        }
        switch (((WCTMenu)this.getMenu()).getMagnetMode()) {
            case OFF: {
                ((WCTMenu)this.getMenu()).setMagnetMode(MagnetMode.PICKUP_INVENTORY);
                break;
            }
            case PICKUP_INVENTORY: {
                ((WCTMenu)this.getMenu()).setMagnetMode(MagnetMode.PICKUP_ME);
                break;
            }
            case PICKUP_ME: {
                ((WCTMenu)this.getMenu()).setMagnetMode(MagnetMode.OFF);
            }
        }
    }

    private void setMagnetModeText() {
        switch (((WCTMenu)this.getMenu()).getMagnetMode()) {
            case INVALID: 
            case NO_CARD: {
                this.magnetCardToggleButton.setVisibility(false);
                this.magnetCardMenuButton.setVisibility(false);
                break;
            }
            case OFF: {
                this.magnetCardToggleButton.setVisibility(true);
                this.magnetCardMenuButton.setVisibility(true);
                this.magnetCardToggleButton.setMessage((Component)TextConstants.MAGNETCARD_OFF);
                break;
            }
            case PICKUP_INVENTORY: {
                this.magnetCardToggleButton.setVisibility(true);
                this.magnetCardMenuButton.setVisibility(true);
                this.magnetCardToggleButton.setMessage((Component)TextConstants.MAGNETCARD_INVENTORY);
                break;
            }
            case PICKUP_ME: {
                this.magnetCardToggleButton.setVisibility(true);
                this.magnetCardMenuButton.setVisibility(true);
                this.magnetCardToggleButton.setMessage((Component)TextConstants.MAGNETCARD_ME);
            }
        }
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.setMagnetModeText();
    }

    public boolean keyPressed(int keyCode, int scanCode, int keyPressed) {
        boolean value = super.keyPressed(keyCode, scanCode, keyPressed);
        if (!value) {
            return this.checkForTerminalKeys(keyCode, scanCode);
        }
        return true;
    }

    @Override
    public WTMenuHost getHost() {
        return (WTMenuHost)((WCTMenu)this.getMenu()).getHost();
    }

    public void renderSlot(GuiGraphics guiGraphics, Slot s) {
        if (s instanceof ArmorSlot) {
            ArmorSlot armorSlot = (ArmorSlot)s;
            this.renderArmorSlot(guiGraphics, armorSlot);
        } else {
            super.renderSlot(guiGraphics, s);
        }
    }

    private void renderArmorSlot(GuiGraphics guiGraphics, ArmorSlot s) {
        ItemStack is = s.getItem();
        if (is.isEmpty() && s.isSlotEnabled()) {
            s.icon().getBlitter().dest(s.x, s.y).opacity(s.getOpacityOfIcon()).blit(guiGraphics);
        }
        super.renderSlot(guiGraphics, (Slot)s);
    }
}

