/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct;

import appeng.api.networking.IGridNode;
import appeng.api.storage.ITerminalHost;
import appeng.menu.MenuOpener;
import appeng.menu.SlotSemantic;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.menu.slot.RestrictedInputSlot;
import de.mari_023.ae2wtlib.AE2wtlibSlotSemantics;
import de.mari_023.ae2wtlib.terminal.ArmorSlot;
import de.mari_023.ae2wtlib.terminal.WTMenuHost;
import de.mari_023.ae2wtlib.wct.TrashMenu;
import de.mari_023.ae2wtlib.wct.WCTMenuHost;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetMenu;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetMode;
import de.mari_023.ae2wtlib.wut.ItemWUT;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WCTMenu
extends CraftingTermMenu {
    public static final String ID = "wireless_crafting_terminal";
    public static final MenuType<WCTMenu> TYPE = MenuTypeBuilder.create(WCTMenu::new, WCTMenuHost.class).build("wireless_crafting_terminal");
    public static final String MAGNET_MODE = "magnetMode";
    public static final String MAGNET_MENU = "magnetMenu";
    public static final String TRASH_MENU = "trash";
    private final WCTMenuHost wctMenuHost;

    public WCTMenu(int id, Inventory ip, WCTMenuHost gui) {
        super(TYPE, id, ip, (ITerminalHost)gui, true);
        this.wctMenuHost = gui;
        this.addSlot((Slot)new ArmorSlot(this, this.getPlayerInventory(), ArmorSlot.Armor.HEAD){

            @Override
            public boolean mayPlace(ItemStack stack) {
                BlockItem bItem;
                Item item = stack.getItem();
                return item instanceof BlockItem && (bItem = (BlockItem)item).getBlock() instanceof Equipable || super.mayPlace(stack);
            }
        }, AE2wtlibSlotSemantics.HELMET);
        this.addSlot((Slot)new ArmorSlot(this.getPlayerInventory(), ArmorSlot.Armor.CHEST), AE2wtlibSlotSemantics.CHESTPLATE);
        this.addSlot((Slot)new ArmorSlot(this.getPlayerInventory(), ArmorSlot.Armor.LEGS), AE2wtlibSlotSemantics.LEGGINGS);
        this.addSlot((Slot)new ArmorSlot(this.getPlayerInventory(), ArmorSlot.Armor.FEET), AE2wtlibSlotSemantics.BOOTS);
        if (Integer.valueOf(40).equals(this.wctMenuHost.getPlayerInventorySlot())) {
            this.addSlot((Slot)new ArmorSlot.DisabledOffhandSlot(this.getPlayerInventory()), AE2wtlibSlotSemantics.OFFHAND);
        } else {
            this.addSlot((Slot)new ArmorSlot(this.getPlayerInventory(), ArmorSlot.Armor.OFFHAND), AE2wtlibSlotSemantics.OFFHAND);
        }
        this.addSlot((Slot)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.QE_SINGULARITY, this.wctMenuHost.getSubInventory(WTMenuHost.INV_SINGULARITY), 0), AE2wtlibSlotSemantics.SINGULARITY);
        this.registerClientAction(MAGNET_MODE, MagnetMode.class, this::setMagnetMode);
        this.registerClientAction(MAGNET_MENU, this::openMagnetMenu);
        this.registerClientAction(TRASH_MENU, this::openTrashMenu);
    }

    public IGridNode getNetworkNode() {
        return this.wctMenuHost.getActionableNode();
    }

    public MagnetMode getMagnetMode() {
        return MagnetHandler.getMagnetMode(this.wctMenuHost.getItemStack());
    }

    public void setMagnetMode(MagnetMode mode) {
        if (this.isClientSide()) {
            this.sendClientAction(MAGNET_MODE, (Object)mode);
        }
        MagnetHandler.saveMagnetMode(this.wctMenuHost.getItemStack(), mode);
    }

    public void openMagnetMenu() {
        if (this.isClientSide()) {
            this.sendClientAction(MAGNET_MENU);
            return;
        }
        MenuOpener.open(MagnetMenu.TYPE, (Player)this.getPlayer(), (MenuHostLocator)this.getLocator());
    }

    public void openTrashMenu() {
        if (this.isClientSide()) {
            this.sendClientAction(TRASH_MENU);
            return;
        }
        MenuOpener.open(TrashMenu.TYPE, (Player)this.getPlayer(), (MenuHostLocator)this.getLocator());
    }

    protected boolean canSlotsBeHidden(SlotSemantic semantic) {
        return semantic == AE2wtlibSlotSemantics.OFFHAND || semantic == AE2wtlibSlotSemantics.HELMET || semantic == AE2wtlibSlotSemantics.CHESTPLATE || semantic == AE2wtlibSlotSemantics.LEGGINGS || semantic == AE2wtlibSlotSemantics.BOOTS;
    }

    public boolean isWUT() {
        return this.wctMenuHost.getItemStack().getItem() instanceof ItemWUT;
    }
}

