/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.menu.locator.ItemMenuHostLocator;
import de.mari_023.ae2wtlib.AE2wtlibComponents;
import de.mari_023.ae2wtlib.terminal.WTMenuHost;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHost;
import de.mari_023.ae2wtlib.wut.WTDefinitions;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.HashMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class CraftingTerminalHandler {
    public final Player player;
    @Nullable
    private WTMenuHost menuHost;
    @Nullable
    private ItemMenuHostLocator locator;
    private HashMap<Item, Long> restockAbleItems = new HashMap();
    @Nullable
    private MagnetHost magnetHost;

    @ApiStatus.Internal
    public CraftingTerminalHandler(Player player) {
        this.player = player;
    }

    public static CraftingTerminalHandler getCraftingTerminalHandler(Player player) {
        return (CraftingTerminalHandler)player.getData(AE2wtlibComponents.CT_HANDLER);
    }

    private void invalidateCache() {
        this.menuHost = null;
        this.locator = null;
        this.restockAbleItems.clear();
        this.magnetHost = null;
    }

    public ItemStack getCraftingTerminal() {
        this.getLocator();
        if (this.locator != null) {
            return this.locator.locateItem(this.player);
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    private WTMenuHost getMenuHost() {
        if (this.menuHost != null) {
            if (!this.menuHost.isValid()) {
                this.invalidateCache();
                return this.getMenuHost();
            }
            return this.menuHost;
        }
        this.getLocator();
        this.menuHost = this.locator == null ? null : (WTMenuHost)((Object)this.locator.locate(this.player, WTMenuHost.class));
        if (this.menuHost == null) {
            this.invalidateCache();
        }
        return this.menuHost;
    }

    @Nullable
    public ItemMenuHostLocator getLocator() {
        if (this.locator != null && WUTHandler.hasTerminal(this.locator.locateItem(this.player), WTDefinitions.CRAFTING)) {
            return this.locator;
        }
        boolean locatorWasNotNull = this.locator != null;
        this.locator = WUTHandler.findTerminal(this.player, WTDefinitions.CRAFTING);
        if (this.locator == null) {
            this.invalidateCache();
            if (locatorWasNotNull) {
                return this.getLocator();
            }
        }
        return this.locator;
    }

    @Nullable
    public IGrid getTargetGrid() {
        if (this.getMenuHost() == null) {
            return null;
        }
        IGridNode n = this.getMenuHost().getActionableNode();
        if (n == null) {
            return null;
        }
        return n.getGrid();
    }

    public boolean inRange() {
        if (this.getMenuHost() == null) {
            return false;
        }
        this.getMenuHost().updateConnectedAccessPoint();
        this.getMenuHost().updateLinkStatus();
        return this.getMenuHost().getLinkStatus().connected();
    }

    public long getAccessibleAmount(ItemStack stack) {
        return (long)stack.getCount() + (this.restockAbleItems.get(stack.getItem()) == null ? 0L : this.restockAbleItems.get(stack.getItem()));
    }

    public boolean isRestockAble(ItemStack stack) {
        return this.restockAbleItems.containsKey(stack.getItem());
    }

    public void setRestockAbleItems(HashMap<Item, Long> items) {
        this.restockAbleItems = items;
    }

    @Nullable
    public MagnetHost getMagnetHost() {
        if (this.magnetHost == null) {
            if (this.getLocator() == null) {
                this.magnetHost = null;
                return null;
            }
            this.magnetHost = new MagnetHost(this);
        }
        return this.magnetHost;
    }
}

