/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.terminal;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.features.Locatables;
import appeng.api.ids.AEComponents;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.ILinkStatus;
import appeng.api.storage.MEStorage;
import appeng.api.storage.SupplierStorage;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.contents.StackDependentSupplier;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.me.storage.NullInventory;
import appeng.menu.ISubMenu;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.SupplierInternalInventory;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.AE2wtlibComponents;
import de.mari_023.ae2wtlib.AE2wtlibItems;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.terminal.results.ActionHostResult;
import de.mari_023.ae2wtlib.terminal.results.LongResult;
import de.mari_023.ae2wtlib.terminal.results.Status;
import de.mari_023.ae2wtlib.wut.WTDefinition;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public abstract class WTMenuHost
extends WirelessTerminalMenuHost<ItemWT>
implements ISegmentedInventory {
    private final SupplierInternalInventory<InternalInventory> singularityInventory;
    private final SupplierInternalInventory<InternalInventory> viewCellInventory;
    @Nullable
    private IActionHost quantumBridge;
    public static final ResourceLocation INV_SINGULARITY = AE2wtlib.id("singularity");
    private final MEStorage storage = new SupplierStorage((Supplier)new StackDependentSupplier(() -> ((WTMenuHost)this).getItemStack(), this::getStorageFromStack));
    private @UnknownNullability ILinkStatus linkStatus;
    private @UnknownNullability ILinkStatus quantumStatus;
    private final String closeHotkey;

    public WTMenuHost(ItemWT item, Player player, ItemMenuHostLocator locator, BiConsumer<Player, ISubMenu> returnToMainMenu) {
        super((WirelessTerminalItem)item, player, locator, returnToMainMenu);
        this.viewCellInventory = new SupplierInternalInventory((Supplier)new StackDependentSupplier(() -> ((WTMenuHost)this).getItemStack(), stack -> WTMenuHost.createInv(player, stack, AE2wtlibComponents.VIEW_CELL_INVENTORY, 5)));
        this.singularityInventory = new SupplierInternalInventory((Supplier)new StackDependentSupplier(() -> ((WTMenuHost)this).getItemStack(), stack -> WTMenuHost.createSingularityInv(player, stack)));
        String close = super.getCloseHotkey();
        WTDefinition wtDefinition = WTDefinition.ofOrNull(this.getItemStack());
        if (wtDefinition != null) {
            close = wtDefinition.hotkeyName();
        }
        assert (close != null);
        this.closeHotkey = close;
    }

    public String getCloseHotkey() {
        return this.closeHotkey;
    }

    public MEStorage getInventory() {
        return this.storage;
    }

    @Nullable
    private MEStorage getStorageFromStack(ItemStack stack) {
        this.updateConnectedAccessPoint();
        IGridNode node = this.getActionableNode();
        if (node == null) {
            return NullInventory.of();
        }
        IGrid targetGrid = node.getGrid();
        if (targetGrid != null) {
            return targetGrid.getStorageService().getInventory();
        }
        return NullInventory.of();
    }

    @Nullable
    public IGridNode getActionableNode() {
        if (!this.getPlayer().level().isClientSide() && this.quantumStatus.connected()) {
            assert (this.quantumBridge != null);
            return this.quantumBridge.getActionableNode();
        }
        return super.getActionableNode();
    }

    public void updateLinkStatus() {
        super.updateLinkStatus();
        this.linkStatus = super.getLinkStatus();
        if (this.linkStatus.connected()) {
            return;
        }
        if (this.quantumStatus.equals((Object)ILinkStatus.ofDisconnected())) {
            return;
        }
        this.linkStatus = this.quantumStatus;
    }

    public ILinkStatus getLinkStatus() {
        return this.linkStatus;
    }

    public void updateConnectedAccessPoint() {
        super.updateConnectedAccessPoint();
        this.quantumStatus = this.isQuantumLinked();
    }

    public ActionHostResult findQuantumBridge(Level level, long frequency) {
        IActionHost quantumBridge = (IActionHost)Locatables.quantumNetworkBridges().get(level, frequency);
        if (quantumBridge == null) {
            quantumBridge = (IActionHost)Locatables.quantumNetworkBridges().get(level, -frequency);
        }
        if (quantumBridge == null) {
            return ActionHostResult.invalid(Status.BridgeNotFound);
        }
        return ActionHostResult.valid(quantumBridge);
    }

    public LongResult getQEFrequency() {
        ItemStack singularity = (ItemStack)this.getItemStack().getOrDefault(AE2wtlibComponents.SINGULARITY, (Object)ItemStack.EMPTY);
        if (singularity.isEmpty()) {
            return LongResult.invalid(Status.NoSingularity);
        }
        Long singularityID = (Long)singularity.get(AEComponents.ENTANGLED_SINGULARITY_ID);
        if (singularityID == null) {
            return LongResult.invalid(Status.GenericInvalid);
        }
        return LongResult.valid(singularityID);
    }

    private ILinkStatus isQuantumLinked() {
        LongResult f;
        Status status = Status.Valid;
        if (!this.getUpgrades().isInstalled((ItemLike)AE2wtlibItems.QUANTUM_BRIDGE_CARD)) {
            status = Status.NoUpgrade;
        }
        if (!(f = this.getQEFrequency()).valid()) {
            Status status2 = status = status.isValid() ? f.status() : Status.GenericInvalid;
        }
        if (!status.isValid()) {
            return status.toILinkStatus();
        }
        long frequency = f.result();
        if (this.quantumBridge == null) {
            ActionHostResult qb = this.findQuantumBridge(this.getPlayer().level(), frequency);
            this.quantumBridge = qb.host();
            if (qb.invalid()) {
                return qb.status().toILinkStatus();
            }
            assert (this.quantumBridge != null);
        } else {
            Object qb = this.quantumBridge;
            if (qb instanceof QuantumCluster) {
                QuantumCluster quantumCluster = (QuantumCluster)qb;
                if (quantumCluster.getCenter() == null) {
                    return Status.BridgeNotFound.toILinkStatus();
                }
                long frequencyOther = quantumCluster.getCenter().getQEFrequency();
                if (frequencyOther != frequency && frequencyOther != -frequency && this.findQuantumBridge(this.getPlayer().level(), frequency).invalid()) {
                    return Status.BridgeNotFound.toILinkStatus();
                }
            } else {
                qb = this.findQuantumBridge(this.getPlayer().level(), frequency);
                this.quantumBridge = ((ActionHostResult)qb).host();
                if (qb.invalid()) {
                    return ((ActionHostResult)qb).status().toILinkStatus();
                }
                assert (this.quantumBridge != null);
            }
        }
        if (this.quantumBridge.getActionableNode() == null || this.quantumBridge.getActionableNode().getGrid() == null) {
            return Status.BridgeNotFound.toILinkStatus();
        }
        IGrid targetGrid = ((ItemWT)this.getItem()).getLinkedGrid(this.getItemStack(), this.getPlayer().level(), null);
        if (this.quantumBridge.getActionableNode().getGrid() != targetGrid && targetGrid != null) {
            return Status.DifferentNetworks.toILinkStatus();
        }
        if (!this.quantumBridge.getActionableNode().getGrid().getEnergyService().isNetworkPowered()) {
            return Status.NotPowered.toILinkStatus();
        }
        return ILinkStatus.ofConnected();
    }

    public InternalInventory getViewCellStorage() {
        return this.viewCellInventory;
    }

    protected double getPowerDrainPerTick() {
        if (this.quantumStatus.connected() || Status.NotPowered.is(this.quantumStatus)) {
            return 22.5;
        }
        return super.getPowerDrainPerTick();
    }

    public boolean consumeIdlePower(Actionable action) {
        if (action == Actionable.SIMULATE) {
            this.recharge();
        }
        boolean success = super.consumeIdlePower(action);
        if (action == Actionable.SIMULATE) {
            this.recharge();
        }
        return success;
    }

    private void recharge() {
        if (!this.quantumStatus.connected() && !Status.NotPowered.is(this.quantumStatus)) {
            return;
        }
        Item item = this.getItemStack().getItem();
        if (!(item instanceof AEBasePoweredItem)) {
            return;
        }
        AEBasePoweredItem item2 = (AEBasePoweredItem)item;
        double missing = item2.getAEMaxPower(this.getItemStack()) - item2.getAECurrentPower(this.getItemStack());
        if (this.getActionableNode() == null || missing <= 0.0) {
            return;
        }
        IEnergyService energyService = this.getActionableNode().getGrid().getEnergyService();
        double safePower = energyService.getStoredPower() - energyService.getMaxStoredPower() / 2.0;
        if (safePower <= 0.0) {
            return;
        }
        double toMove = Math.min(missing, safePower);
        double extracted = energyService.extractAEPower(toMove, Actionable.MODULATE, PowerMultiplier.ONE);
        item2.injectAEPower(this.getItemStack(), extracted, Actionable.MODULATE);
    }

    @Nullable
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)INV_SINGULARITY)) {
            return this.singularityInventory;
        }
        return null;
    }

    protected static InternalInventory createInv(final Player player, final ItemStack stack, final DataComponentType<ItemContainerContents> componentType, int size) {
        AppEngInternalInventory craftingGrid = new AppEngInternalInventory(new InternalInventoryHost(){

            public void saveChangedInventory(AppEngInternalInventory inv) {
                stack.set(componentType, (Object)inv.toItemContainerContents());
            }

            public boolean isClientSide() {
                return player.level().isClientSide();
            }
        }, size);
        craftingGrid.fromItemContainerContents((ItemContainerContents)stack.getOrDefault(componentType, (Object)ItemContainerContents.EMPTY));
        return craftingGrid;
    }

    private static InternalInventory createSingularityInv(final Player player, final ItemStack stack) {
        AppEngInternalInventory inv = new AppEngInternalInventory(new InternalInventoryHost(){

            public void saveChangedInventory(AppEngInternalInventory inv) {
                stack.set(AE2wtlibComponents.SINGULARITY, (Object)inv.getStackInSlot(0));
            }

            public boolean isClientSide() {
                return player.level().isClientSide();
            }
        }, 1, 1);
        inv.setItemDirect(0, (ItemStack)stack.getOrDefault(AE2wtlibComponents.SINGULARITY, (Object)ItemStack.EMPTY));
        return inv;
    }
}

