/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.terminal;

import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.Upgrades;
import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.Rects;
import appeng.client.gui.Tooltip;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.localization.GuiText;
import appeng.menu.slot.AppEngSlot;
import de.mari_023.ae2wtlib.AE2wtlibItems;
import de.mari_023.ae2wtlib.terminal.UpgradeBackground;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ScrollingUpgradesPanel
implements ICompositeWidget {
    private static final int SLOT_SIZE = 18;
    private static final int PADDING = 5;
    private static final int SCROLLBAR_WIDTH = 5;
    private final List<Slot> slots;
    private final Supplier<IUpgradeInventory> upgrades;
    private Point screenOrigin = Point.ZERO;
    private int x;
    private int y;
    private int maxRows = 2;
    private final Scrollbar scrollbar;
    private final List<Component> tooltips;

    public ScrollingUpgradesPanel(List<Slot> slots, IUpgradeableObject upgradeableObject, WidgetContainer widgets, Supplier<IUpgradeInventory> upgrades) {
        this.slots = slots;
        this.upgrades = upgrades;
        this.tooltips = Upgrades.getTooltipLinesForMachine((ItemLike)upgradeableObject.getUpgrades().getUpgradableItem());
        this.tooltips.addFirst((Component)GuiText.CompatibleUpgrades.text());
        this.scrollbar = widgets.addScrollBar("upgradeScrollbar", Scrollbar.SMALL);
        this.scrollbar.setCaptureMouseWheel(false);
        this.setScrollbarRange();
    }

    private boolean singularitySlotHidden() {
        return this.isDisabledSlotEmpty((AppEngSlot)this.slots.getFirst()) && !this.upgrades.get().isInstalled((ItemLike)AE2wtlibItems.QUANTUM_BRIDGE_CARD);
    }

    private boolean isDisabledSlotEmpty(AppEngSlot slot) {
        boolean enabled = slot.isSlotEnabled();
        slot.setSlotEnabled(true);
        ItemStack stack = slot.getItem();
        slot.setSlotEnabled(enabled);
        return stack.isEmpty();
    }

    public void setMaxRows(int rows) {
        this.maxRows = rows;
        this.setScrollbarRange();
    }

    public void setPosition(Point position) {
        this.x = position.getX();
        this.y = position.getY();
    }

    public void setSize(int width, int height) {
    }

    public Rect2i getBounds() {
        int height = 10 + this.getVisibleSlotCount() * 18;
        int width = 28 + (this.scrolling() ? 5 : 0);
        return new Rect2i(this.x, this.y, width, height);
    }

    public void populateScreen(Consumer<AbstractWidget> addWidget, Rect2i bounds, AEBaseScreen<?> screen) {
        this.screenOrigin = Point.fromTopLeft((Rect2i)bounds);
    }

    public void updateBeforeRender() {
        int slotOriginX = this.x;
        int slotOriginY = this.y + 5;
        int currentFirstSlot = this.scrollbar.getCurrentScroll();
        this.setScrollbarRange();
        int i = 0;
        for (Slot s : this.slots) {
            if (!(s instanceof AppEngSlot)) continue;
            AppEngSlot slot = (AppEngSlot)s;
            if (s == this.slots.getFirst() && this.singularitySlotHidden()) {
                ((AppEngSlot)this.slots.getFirst()).setSlotEnabled(false);
                continue;
            }
            slot.setSlotEnabled(currentFirstSlot <= i && currentFirstSlot + this.maxRows > i);
            ++i;
            if (!slot.isActive()) continue;
            slot.x = slotOriginX + 1;
            slot.y = slotOriginY + 1;
            slotOriginY += 18;
        }
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        int slotCount = this.getVisibleSlotCount();
        if (slotCount <= 0) {
            return;
        }
        int slotOriginX = this.screenOrigin.getX() + this.x;
        int slotOriginY = this.screenOrigin.getY() + this.y + 5;
        UpgradeBackground bg = UpgradeBackground.get(this.scrolling());
        bg.top().getBlitter().dest(slotOriginX, slotOriginY - 5).blit(guiGraphics);
        for (int i = 1; i < slotCount - 1; ++i) {
            bg.middle().getBlitter().dest(slotOriginX, slotOriginY + i * 18).blit(guiGraphics);
        }
        bg.bottom().getBlitter().dest(slotOriginX, slotOriginY + (slotCount - 1) * 18).blit(guiGraphics);
    }

    public void addExclusionZones(List<Rect2i> exclusionZones, Rect2i screenBounds) {
        exclusionZones.add(Rects.expand((Rect2i)Rects.move((Rect2i)this.getBounds(), (int)screenBounds.getX(), (int)screenBounds.getY()), (int)2));
    }

    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        if (this.getUpgradeSlotCount() == 0) {
            return null;
        }
        return new Tooltip(this.tooltips);
    }

    private int getUpgradeSlotCount() {
        int count = 0;
        for (Slot slot : this.slots) {
            if (!(slot instanceof AppEngSlot)) continue;
            ++count;
        }
        if (this.singularitySlotHidden()) {
            --count;
        }
        return count;
    }

    private void setScrollbarRange() {
        this.scrollbar.setRange(0, this.getUpgradeSlotCount() - this.getVisibleSlotCount(), 1);
        this.scrollbar.setVisible(this.scrolling());
    }

    private int getVisibleSlotCount() {
        return Math.min(this.maxRows, this.getUpgradeSlotCount());
    }

    private boolean scrolling() {
        return this.getUpgradeSlotCount() > this.maxRows;
    }

    public boolean onMouseWheel(Point mousePos, double delta) {
        return this.scrollbar.onMouseWheel(mousePos, delta);
    }
}

