/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.terminal;

import appeng.client.gui.widgets.ITooltip;
import de.mari_023.ae2wtlib.terminal.Icon;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class IconButton
extends Button
implements ITooltip {
    private final Icon icon;
    private final Icon bg;
    private final Icon bg_hovered;
    private final Icon bg_focused;
    @Nullable
    private List<Component> tooltip;

    public IconButton(Button.OnPress onPress, Icon icon) {
        this(onPress, icon, Icon.BUTTON_BACKGROUND, Icon.BUTTON_BACKGROUND_HOVERED, Icon.BUTTON_BACKGROUND_FOCUSED);
    }

    public IconButton(Button.OnPress onPress, Icon icon, Icon bg, Icon bg_hovered, Icon bg_focused) {
        super(0, 0, 16, 16, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.icon = icon;
        this.bg = bg;
        this.bg_hovered = bg_hovered;
        this.bg_focused = bg_focused;
    }

    public static IconButton withAE2Background(Button.OnPress onPress, Icon icon) {
        return new IconButton(onPress, icon, Icon.TOOLBAR_BUTTON_BACKGROUND, Icon.TOOLBAR_BUTTON_BACKGROUND_HOVERED, Icon.TOOLBAR_BUTTON_BACKGROUND_FOCUSED);
    }

    public void setVisibility(boolean vis) {
        this.visible = vis;
        this.active = vis;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (!this.visible) {
            return;
        }
        int yOffset = this.isHovered() ? 1 : 0;
        Icon bg = this.getBG();
        int bgSizeOffset = bg.width() > 16 ? 1 : 0;
        bg.getBlitter().dest(this.getX() - 1, this.getY() + yOffset, bg.width(), bg.height()).zOffset(2).blit(guiGraphics);
        this.getIcon().getBlitter().dest(this.getX() - 1 + bgSizeOffset, this.getY() + bgSizeOffset + yOffset).zOffset(3).blit(guiGraphics);
    }

    protected Icon getIcon() {
        return this.icon;
    }

    private Icon getBG() {
        return this.isHovered() ? this.bg_hovered : (this.isFocused() ? this.bg_focused : this.bg);
    }

    public List<Component> getTooltipMessage() {
        if (this.tooltip == null) {
            return Collections.singletonList(this.getMessage());
        }
        return this.tooltip;
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(this.getX(), this.getY(), this.getBG().width(), this.getBG().height());
    }

    public boolean isTooltipAreaVisible() {
        return this.visible;
    }

    @Contract(value="_ -> this")
    public IconButton withTooltip(Component message) {
        super.setMessage(message);
        return this;
    }

    @Contract(value="_ -> this")
    public IconButton withTooltip(List<Component> tooltip) {
        this.tooltip = tooltip;
        return this;
    }
}

