/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.networking;

import appeng.menu.AEBaseMenu;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.menu.locator.MenuHostLocator;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.networking.AE2wtlibPacket;
import de.mari_023.ae2wtlib.wut.ItemWUT;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public record CycleTerminalPacket(boolean isRightClick) implements AE2wtlibPacket
{
    public static final CustomPacketPayload.Type<CycleTerminalPacket> ID = new CustomPacketPayload.Type(AE2wtlib.id("cycle_terminal"));
    public static final StreamCodec<ByteBuf, CycleTerminalPacket> STREAM_CODEC = ByteBufCodecs.BOOL.map(CycleTerminalPacket::new, CycleTerminalPacket::isRightClick);

    @Override
    public void processPacketData(Player player) {
        AbstractContainerMenu containerMenu = player.containerMenu;
        if (!(containerMenu instanceof AEBaseMenu)) {
            return;
        }
        AEBaseMenu aeMenu = (AEBaseMenu)containerMenu;
        MenuHostLocator menuHostLocator = aeMenu.getLocator();
        if (!(menuHostLocator instanceof ItemMenuHostLocator)) {
            return;
        }
        ItemMenuHostLocator locator = (ItemMenuHostLocator)menuHostLocator;
        ItemStack item = locator.locateItem(player);
        if (!(item.getItem() instanceof ItemWUT)) {
            return;
        }
        WUTHandler.cycle(player, locator, item, this.isRightClick());
        WUTHandler.open(player, locator, true);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

