/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib;

import appeng.block.networking.WirelessAccessPointBlock;
import appeng.blockentity.qnb.QuantumBridgeBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.server.testplots.CraftingPatternHelper;
import appeng.server.testplots.TestPlot;
import appeng.server.testplots.TestPlotClass;
import appeng.server.testworld.PlotBuilder;
import de.mari_023.ae2wtlib.AE2wtlibItems;
import de.mari_023.ae2wtlib.wut.WTDefinition;
import de.mari_023.ae2wtlib.wut.recipe.Common;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

@TestPlotClass
public class AE2wtlibTestPlots {
    @TestPlot(value="wireless_terminal")
    public static void wireless_terminal(PlotBuilder plot) {
        BlockPos o = BlockPos.ZERO;
        plot.creativeEnergyCell(o);
        plot.cable("[1,17] 0 0");
        plot.blockState(o.east(17).above(), (BlockState)((WirelessAccessPointBlock)AEBlocks.WIRELESS_ACCESS_POINT.block()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP));
        plot.block(o.north().below(), Blocks.RED_WOOL);
        plot.block(o.north().below().east(), Blocks.GREEN_WOOL);
        plot.block(o.above(), AEBlocks.QUARTZ_VIBRANT_GLASS);
        plot.block(o.above().east(), AEBlocks.QUARTZ_VIBRANT_GLASS);
        plot.block("[2,4] [0,2] 1", AEBlocks.QUANTUM_RING);
        plot.blockEntity(o.above().east(3).south(), AEBlocks.QUANTUM_LINK, quantumBridge -> {
            ItemStack singularity = AEItems.QUANTUM_ENTANGLED_SINGULARITY.stack();
            QuantumBridgeBlockEntity.assignFrequency((ItemStack)singularity);
            quantumBridge.getInternalInventory().addItems(singularity, false);
        });
    }

    @TestPlot(value="universal_terminal")
    public static void universal_terminal(PlotBuilder plot) {
        ItemStack stack1 = AEItems.WIRELESS_CRAFTING_TERMINAL.stack();
        ItemStack stack2 = new ItemStack((ItemLike)AE2wtlibItems.PATTERN_ACCESS_TERMINAL);
        ItemStack stack3 = new ItemStack((ItemLike)AE2wtlibItems.PATTERN_ENCODING_TERMINAL);
        ItemStack universalStack = Common.mergeTerminal(Common.mergeTerminal(new ItemStack((ItemLike)AE2wtlibItems.UNIVERSAL_TERMINAL), stack1, WTDefinition.of(stack1)), stack2, WTDefinition.of(stack2));
        plot.hopper("2 2 0", Direction.WEST, new ItemStack[]{stack2});
        plot.hopper("1 3 0", Direction.DOWN, new ItemStack[]{stack1});
        plot.creativeEnergyCell("1 2 1");
        plot.blockEntity("1 2 0", AEBlocks.MOLECULAR_ASSEMBLER, molecularAssembler -> {
            ServerLevel level = (ServerLevel)Objects.requireNonNull(molecularAssembler.getLevel());
            molecularAssembler.getInternalInventory().setItemDirect(10, CraftingPatternHelper.encodeShapelessCraftingRecipe((Level)level, (ItemStack[])new ItemStack[]{stack1, stack2}));
        });
        plot.hopper("1 1 0", Direction.WEST, new ItemStack[0]);
        plot.hopper("0 2 0", Direction.DOWN, new ItemStack[]{stack3});
        plot.creativeEnergyCell("0 1 1");
        plot.blockEntity("0 1 0", AEBlocks.MOLECULAR_ASSEMBLER, molecularAssembler -> {
            ServerLevel level = (ServerLevel)Objects.requireNonNull(molecularAssembler.getLevel());
            molecularAssembler.getInternalInventory().setItemDirect(10, CraftingPatternHelper.encodeShapelessCraftingRecipe((Level)level, (ItemStack[])new ItemStack[]{universalStack, stack3}));
        });
        plot.hopper("0 0 0", Direction.DOWN, new ItemStack[0]);
        plot.test(test -> test.assertTrue(test.countContainerContentAt(BlockPos.ZERO).isEmpty(), "Failed to craft universal Terminal"));
    }
}

