/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib;

import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.AE2wtlibComponents;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.AE2wtlibCreativeTab;
import de.mari_023.ae2wtlib.AE2wtlibEvents;
import de.mari_023.ae2wtlib.AE2wtlibItems;
import de.mari_023.ae2wtlib.networking.AE2wtlibPacket;
import de.mari_023.ae2wtlib.networking.CycleTerminalPacket;
import de.mari_023.ae2wtlib.networking.RestockAmountPacket;
import de.mari_023.ae2wtlib.networking.UpdateRestockPacket;
import de.mari_023.ae2wtlib.networking.UpdateWUTPackage;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import net.neoforged.neoforge.event.entity.player.ArrowNockEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="ae2wtlib")
@EventBusSubscriber
public class AE2wtlibForge {
    public AE2wtlibForge(IEventBus modEventBus) {
        CommonHooks.markComponentClassAsValid(ItemStack.class);
        AE2wtlib.registerMenus();
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AE2wtlibConfig.SPEC, "ae2wtlib.toml");
        modEventBus.addListener(e -> {
            if (!e.getRegistryKey().equals(Registries.BLOCK)) {
                return;
            }
            AE2wtlibItems.init();
            AE2wtlib.onAe2Initialized();
            AE2wtlibCreativeTab.init();
            for (Map.Entry<ResourceLocation, DataComponentType<?>> entry : AE2wtlibComponents.DR.entrySet()) {
                Registry.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (ResourceLocation)entry.getKey(), entry.getValue());
            }
        });
        modEventBus.addListener(e -> AE2wtlib.addToCreativeTab());
        modEventBus.addListener(event -> {
            PayloadRegistrar registrar = event.registrar("ae2wtlib");
            AE2wtlibForge.registerPacket(registrar, CycleTerminalPacket.ID, CycleTerminalPacket.STREAM_CODEC);
            AE2wtlibForge.registerPacket(registrar, UpdateWUTPackage.ID, UpdateWUTPackage.STREAM_CODEC);
            AE2wtlibForge.registerPacket(registrar, UpdateRestockPacket.ID, UpdateRestockPacket.STREAM_CODEC);
            AE2wtlibForge.registerPacket(registrar, RestockAmountPacket.ID, RestockAmountPacket.STREAM_CODEC);
        });
        modEventBus.addListener(AE2wtlib::registerScreens);
        modEventBus.addListener(event -> {
            AE2wtlibForge.registerPowerStorageItem(event, AE2wtlibItems.UNIVERSAL_TERMINAL);
            AE2wtlibForge.registerPowerStorageItem(event, AE2wtlibItems.PATTERN_ACCESS_TERMINAL);
            AE2wtlibForge.registerPowerStorageItem(event, AE2wtlibItems.PATTERN_ENCODING_TERMINAL);
        });
        AE2wtlib.ATTACHMENT_TYPES.register(modEventBus);
    }

    private static <T extends AE2wtlibPacket> void registerPacket(PayloadRegistrar registrar, CustomPacketPayload.Type<T> id, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
        registrar.playBidirectional(id, streamCodec, (packet, context) -> context.enqueueWork(() -> packet.processPacketData(context.player())));
    }

    private static void registerPowerStorageItem(RegisterCapabilitiesEvent event, ItemWT item) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (object, context) -> new PoweredItemCapabilities(object, (IAEItemPowerStorage)item), new ItemLike[]{item});
    }

    @SubscribeEvent
    public static void handle(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        AE2wtlibEvents.restock(player, event.getItem(), event.getResultStack().getCount(), arg_0 -> ((LivingEntityUseItemEvent.Finish)event).setResultStack(arg_0));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handle(PlayerInteractEvent.RightClickBlock event) {
        ServerPlayer player;
        block3: {
            block2: {
                Player player2 = event.getEntity();
                if (!(player2 instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)player2;
                if (!event.isCanceled()) break block3;
            }
            return;
        }
        ItemStack item = event.getItemStack();
        AE2wtlibEvents.restock(player, item, item.getCount(), stack -> player.setItemInHand(event.getHand(), stack));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handle(PlayerInteractEvent.EntityInteractSpecific event) {
        ServerPlayer player;
        block3: {
            block2: {
                Player player2 = event.getEntity();
                if (!(player2 instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)player2;
                if (!event.isCanceled()) break block3;
            }
            return;
        }
        ItemStack item = event.getItemStack();
        AE2wtlibEvents.restock(player, item, item.getCount(), stack -> player.setItemInHand(event.getHand(), stack));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handle(ItemEntityPickupEvent.Pre event) {
        if (event.canPickup().isFalse()) {
            return;
        }
        ItemEntity entity = event.getItemEntity();
        Player player = event.getPlayer();
        if (event.canPickup().isDefault()) {
            if (entity.hasPickUpDelay()) {
                return;
            }
            if (entity.target != null && !entity.target.equals(player.getUUID())) {
                return;
            }
        }
        AE2wtlibEvents.insertStackInME(entity, player);
    }

    @SubscribeEvent
    public static void handle(ArrowNockEvent event) {
        if (!event.hasAmmo()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack projectile = player2.getProjectile(event.getBow());
        AE2wtlibEvents.restock(player2, projectile, projectile.getCount(), itemStack -> {});
    }

    @SubscribeEvent
    public static void handle(ArrowLooseEvent event) {
        if (!event.hasAmmo()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack projectile = player2.getProjectile(event.getBow());
        AE2wtlibEvents.restock(player2, projectile, projectile.getCount(), itemStack -> {});
    }
}

