/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib;

import appeng.api.config.Actionable;
import appeng.items.tools.powered.WirelessTerminalItem;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.AE2wtlibItems;
import de.mari_023.ae2wtlib.TextConstants;
import de.mari_023.ae2wtlib.wut.ItemWUT;
import de.mari_023.ae2wtlib.wut.WTDefinition;
import de.mari_023.ae2wtlib.wut.recipe.Common;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AE2wtlibCreativeTab {
    private static final List<ItemStack> items = new ArrayList<ItemStack>();

    public static void init() {
        CreativeModeTab tab = CreativeModeTab.builder().title(TextConstants.CREATIVE_TAB).icon(() -> {
            ItemWUT terminal = AE2wtlibItems.UNIVERSAL_TERMINAL;
            ItemStack stack = new ItemStack((ItemLike)terminal);
            terminal.injectAEPower(stack, terminal.getAEMaxPower(stack), Actionable.MODULATE);
            return stack;
        }).displayItems(AE2wtlibCreativeTab::buildDisplayItems).build();
        Registry.register((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, (ResourceLocation)AE2wtlib.id("main"), (Object)tab);
    }

    public static boolean registrationHappened() {
        return !items.isEmpty();
    }

    public static synchronized void add(Item item) {
        items.add(new ItemStack((ItemLike)item));
    }

    public static synchronized void addTerminal(WirelessTerminalItem terminal) {
        ItemStack stack = new ItemStack((ItemLike)terminal);
        items.add(stack.copy());
        terminal.injectAEPower(stack, terminal.getAEMaxPower(stack), Actionable.MODULATE);
        items.add(stack.copy());
    }

    public static synchronized void addUniversalTerminal(ItemWUT wut) {
        ItemStack stack = new ItemStack((ItemLike)wut);
        items.add(stack.copy());
        for (WTDefinition terminal : WTDefinition.wirelessTerminals()) {
            Common.mergeTerminal(stack, new ItemStack((ItemLike)terminal.item()), terminal);
        }
        wut.injectAEPower(stack, wut.getAEMaxPower(stack), Actionable.MODULATE);
        items.add(stack.copy());
    }

    private static synchronized void buildDisplayItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        output.acceptAll(items);
    }
}

