/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.mixins;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.kubedex.KubedexPayloadHandler;
import java.util.Collection;
import moe.wolfgirl.probejs.GlobalStates;
import moe.wolfgirl.probejs.utils.JsonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KubedexPayloadHandler.class}, remap=false)
public class KubedexMixin {
    @Inject(method={"itemStacks"}, remap=false, at={@At(value="RETURN")})
    private static void handleItem(ServerPlayer player, Collection<ItemStack> stacks, CallbackInfo ci) {
        RegistryOps ops = player.server.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (GlobalStates.SERVER != null) {
            GlobalStates.SERVER.broadcast("accept_items", JsonUtils.parseObject(stacks.stream().map(s -> s.kjs$toItemString0((DynamicOps)ops)).toList()));
        }
    }

    @Inject(method={"block"}, remap=false, at={@At(value="RETURN")})
    private static void handleBlock(ServerPlayer player, BlockPos pos, CallbackInfo ci) {
        if (GlobalStates.SERVER != null) {
            RegistryAccess.Frozen access = player.server.registryAccess();
            DefaultedRegistry blockRegistry = BuiltInRegistries.BLOCK;
            BlockState blockState = player.level().getBlockState(pos);
            if (blockState.isAir()) {
                return;
            }
            JsonObject payload = new JsonObject();
            payload.addProperty("id", blockRegistry.getKey((Object)blockState.getBlock()).toString());
            if (!blockState.getValues().isEmpty()) {
                JsonArray properties = new JsonArray();
                blockState.getValues().entrySet().stream().map(StateHolder.PROPERTY_ENTRY_TO_STRING_FUNCTION).map(JsonPrimitive::new).forEach(arg_0 -> ((JsonArray)properties).add(arg_0));
                payload.add("properties", (JsonElement)properties);
            }
            GlobalStates.SERVER.broadcast("accept_block", (JsonElement)payload);
        }
    }
}

