/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.typescript.code.member;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import moe.wolfgirl.probejs.lang.typescript.Declaration;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.utils.NameUtils;

public final class ParamDecl {
    public String name;
    public BaseType type;
    public boolean varArg;
    public boolean optional;

    public ParamDecl(String name, BaseType type, boolean varArg, boolean optional) {
        this.name = name;
        this.type = type;
        this.varArg = varArg;
        this.optional = optional;
    }

    public String format(int index, Declaration declaration) {
        String result;
        String string = result = NameUtils.isNameSafe(this.name) ? this.name : "arg%d".formatted(index);
        if (this.varArg) {
            result = "...%s".formatted(result);
        }
        return "%s%s: %s".formatted(result, this.optional ? "?" : "", this.type.line(declaration, BaseType.FormatType.INPUT));
    }

    public static String formatParams(List<ParamDecl> params, Declaration declaration) {
        ArrayList<String> formattedParams = new ArrayList<String>();
        ListIterator<ParamDecl> it = params.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            ParamDecl param = it.next();
            formattedParams.add(param.format(index, declaration));
        }
        return "(%s)".formatted(String.join((CharSequence)", ", formattedParams));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ParamDecl that = (ParamDecl)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && this.varArg == that.varArg && this.optional == that.optional;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.varArg, this.optional);
    }

    public String toString() {
        return "ParamDecl[name=" + this.name + ", type=" + String.valueOf(this.type) + ", varArg=" + this.varArg + ", optional=" + this.optional + "]";
    }
}

