/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.typescript.code.member;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.typescript.Declaration;
import moe.wolfgirl.probejs.lang.typescript.code.Code;
import moe.wolfgirl.probejs.lang.typescript.code.member.ClassDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.FieldDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.MethodDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.ParamDecl;
import moe.wolfgirl.probejs.lang.typescript.code.ts.MethodDeclaration;
import moe.wolfgirl.probejs.lang.typescript.code.ts.VariableDeclaration;
import moe.wolfgirl.probejs.lang.typescript.code.ts.Wrapped;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSVariableType;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class InterfaceDecl
extends ClassDecl {
    private final Wrapped.Namespace namespace;

    public InterfaceDecl(String name, @Nullable BaseType superClass, List<BaseType> interfaces, List<TSVariableType> variableTypes) {
        super(name, superClass, interfaces, variableTypes);
        this.namespace = new Wrapped.Namespace(name);
    }

    @Override
    public List<String> formatRaw(Declaration declaration) {
        for (MethodDecl method2 : this.methods) {
            method2.isInterface = true;
        }
        String head = "export interface %s".formatted(this.name);
        if (!this.variableTypes.isEmpty()) {
            String variables = this.variableTypes.stream().map(type -> type.line(declaration, BaseType.FormatType.VARIABLE)).collect(Collectors.joining(", "));
            head = "%s<%s>".formatted(head, variables);
        }
        if (!this.interfaces.isEmpty()) {
            String formatted = this.interfaces.stream().map(type -> type.line(declaration)).collect(Collectors.joining(", "));
            head = "%s extends %s".formatted(head, formatted);
        }
        head = "%s {".formatted(head);
        ArrayList<String> body = new ArrayList<String>();
        for (FieldDecl field : this.fields) {
            this.namespace.addCode(new VariableDeclaration(field.name, field.type));
        }
        body.add("");
        for (MethodDecl method3 : this.methods) {
            if (method3.isStatic) {
                this.namespace.addCode(new MethodDeclaration(method3.name, method3.variableTypes, method3.params, method3.returnType));
                continue;
            }
            body.addAll(method3.format(declaration));
        }
        if (this.namespace.isEmpty()) {
            this.namespace.addCode(new Code(this){

                @Override
                public Collection<ClassPath> getUsedClassPaths() {
                    return List.of();
                }

                @Override
                public List<String> format(Declaration declaration) {
                    return List.of("const probejs$$marker: never");
                }
            });
        }
        MutableInt count = new MutableInt(0);
        MethodDecl hybrid = this.methods.stream().filter(method -> !method.isStatic).filter(method -> method.isAbstract).peek(c -> count.add(1)).reduce((a, b) -> b).orElse(null);
        if (count.getValue() == 1 && hybrid != null) {
            body.add("");
            for (ParamDecl param : hybrid.params) {
                param.type = Types.ignoreContext(param.type, BaseType.FormatType.RETURN);
            }
            String hybridBody = ParamDecl.formatParams(hybrid.params, declaration);
            String returnType = hybrid.returnType.line(declaration, BaseType.FormatType.INPUT);
            body.add("%s: %s".formatted(hybridBody, returnType));
        }
        ArrayList<String> formatted = new ArrayList<String>();
        formatted.add(head);
        formatted.addAll(body);
        formatted.add("}\n");
        formatted.addAll(this.namespace.format(declaration));
        return formatted;
    }
}

