/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.typescript;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.ProbePaths;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.java.clazz.Clazz;
import moe.wolfgirl.probejs.lang.transpiler.Transpiler;
import moe.wolfgirl.probejs.lang.typescript.TypeScriptFile;
import moe.wolfgirl.probejs.lang.typescript.code.Code;
import moe.wolfgirl.probejs.lang.typescript.code.member.ClassDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.TypeDecl;
import moe.wolfgirl.probejs.lang.typescript.code.ts.Wrapped;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSJoinedType;
import moe.wolfgirl.probejs.plugin.ProbeJSPlugin;
import moe.wolfgirl.probejs.utils.FileUtils;
import moe.wolfgirl.probejs.utils.GameUtils;
import net.neoforged.api.distmarker.OnlyIn;

public class ScriptDump {
    public static final Supplier<ScriptDump> SERVER_DUMP = () -> {
        ServerScriptManager scriptManager = GameUtils.getServerScriptManager();
        if (scriptManager == null) {
            return null;
        }
        return new ScriptDump((ScriptManager)scriptManager, ProbePaths.PROBE.resolve("server"), KubeJSPaths.SERVER_SCRIPTS, clazz -> {
            for (OnlyIn annotation : clazz.getAnnotations(OnlyIn.class)) {
                if (!annotation.value().isClient()) continue;
                return false;
            }
            return true;
        });
    };
    public static final Supplier<ScriptDump> CLIENT_DUMP = () -> new ScriptDump(KubeJS.getClientScriptManager(), ProbePaths.PROBE.resolve("client"), KubeJSPaths.CLIENT_SCRIPTS, clazz -> {
        for (OnlyIn annotation : clazz.getAnnotations(OnlyIn.class)) {
            if (!annotation.value().isDedicatedServer()) continue;
            return false;
        }
        return true;
    });
    public static final Supplier<ScriptDump> STARTUP_DUMP = () -> new ScriptDump(KubeJS.getStartupScriptManager(), ProbePaths.PROBE.resolve("startup"), KubeJSPaths.STARTUP_SCRIPTS, clazz -> true);
    public final ScriptType scriptType;
    public final ScriptManager manager;
    public final Path basePath;
    public final Path scriptPath;
    public final Map<String, Pair<Collection<String>, Wrapped.Global>> globals;
    public final Transpiler transpiler;
    public final Set<Clazz> recordedClasses = new HashSet<Clazz>();
    private final Predicate<Clazz> accept;
    private final Multimap<ClassPath, TypeDecl> convertibles = ArrayListMultimap.create();
    public int dumped = 0;
    public int total = 0;

    public ScriptDump(ScriptManager manager, Path basePath, Path scriptPath, Predicate<Clazz> scriptPredicate) {
        this.scriptType = manager.scriptType;
        this.manager = manager;
        this.basePath = basePath;
        this.scriptPath = scriptPath;
        this.transpiler = new Transpiler(manager);
        this.globals = new HashMap<String, Pair<Collection<String>, Wrapped.Global>>();
        this.accept = scriptPredicate;
    }

    public void acceptClasses(Collection<Clazz> classes) {
        for (Clazz clazz : classes) {
            if (!this.accept.test(clazz)) continue;
            this.recordedClasses.add(clazz);
        }
    }

    public Set<Class<?>> retrieveClasses() {
        HashSet classes = new HashSet();
        ProbeJSPlugin.forEachPlugin(plugin -> classes.addAll(plugin.provideJavaClass(this)));
        return classes;
    }

    public void assignType(Class<?> classPath, BaseType type) {
        this.assignType(new ClassPath(classPath), type);
    }

    public void assignType(ClassPath classPath, BaseType type) {
        this.convertibles.put((Object)classPath, (Object)new TypeDecl(null, type));
    }

    public void assignType(Class<?> classPath, String name, BaseType type) {
        this.assignType(new ClassPath(classPath), name, type);
    }

    public void assignType(ClassPath classPath, String name, BaseType type) {
        this.convertibles.put((Object)classPath, (Object)new TypeDecl(name, type));
    }

    public void addGlobal(String identifier, Code ... content) {
        this.addGlobal(identifier, List.of(), content);
    }

    public void addGlobal(String identifier, Collection<String> excludedNames, Code ... content) {
        Wrapped.Global global = new Wrapped.Global();
        for (Code code : content) {
            global.addCode(code);
        }
        this.globals.put(identifier, (Pair<Collection<String>, Wrapped.Global>)new Pair(excludedNames, (Object)global));
    }

    public Path ensurePath(String path) {
        return this.ensurePath(path, false);
    }

    public Path ensurePath(String path, boolean script) {
        Path full = (script ? this.scriptPath : this.basePath).resolve(path);
        if (Files.notExists(full, new LinkOption[0])) {
            UtilsJS.tryIO(() -> Files.createDirectories(full, new FileAttribute[0]));
        }
        return full;
    }

    public Path getTypeFolder() {
        return this.ensurePath("probe-types");
    }

    public Path getPackageFolder() {
        return this.ensurePath("probe-types/packages");
    }

    public Path getGlobalFolder() {
        return this.ensurePath("probe-types/global");
    }

    public Path getSource() {
        return this.ensurePath("src", true);
    }

    public Path getTest() {
        return this.ensurePath("test", true);
    }

    public void dumpClasses() throws IOException {
        this.dumped = 0;
        this.total = 0;
        this.transpiler.init();
        ProbeJSPlugin.forEachPlugin(plugin -> {
            try {
                plugin.assignType(this);
            }
            catch (Throwable t) {
                ProbeJS.LOGGER.error(t.getMessage());
                for (StackTraceElement stackTraceElement : t.getStackTrace()) {
                    ProbeJS.LOGGER.error(stackTraceElement.toString());
                }
            }
        });
        HashMap<String, BufferedWriter> files = new HashMap<String, BufferedWriter>();
        Map<ClassPath, TypeScriptFile> globalClasses = this.transpiler.dump(this.recordedClasses);
        ProbeJSPlugin.forEachPlugin(plugin -> plugin.modifyClasses(this, globalClasses));
        this.total = globalClasses.size();
        for (Map.Entry<ClassPath, TypeScriptFile> entry : globalClasses.entrySet()) {
            try {
                ClassPath classPath = entry.getKey();
                StackTraceElement[] output = entry.getValue();
                ClassDecl classDecl = output.findCode(ClassDecl.class).orElse(null);
                if (classDecl == null) continue;
                String symbol = classPath.getName() + "_";
                Object exportedSymbol = "%s$$Type".formatted(classPath.getName());
                BaseType exportedType = Types.type(classPath);
                BaseType thisType = Types.type(classPath);
                List<String> generics = classDecl.variableTypes.stream().map(v -> v.symbol).toList();
                if (!generics.isEmpty()) {
                    String suffix = "<%s>".formatted(String.join((CharSequence)", ", generics));
                    symbol = symbol + suffix;
                    exportedSymbol = (String)exportedSymbol + suffix;
                    thisType = Types.parameterized(thisType, (BaseType[])generics.stream().map(Types::generic).toArray(BaseType[]::new));
                    exportedType = Types.parameterized(exportedType, (BaseType[])generics.stream().map(Types::generic).toArray(BaseType[]::new));
                }
                exportedType = Types.ignoreContext(exportedType, BaseType.FormatType.INPUT);
                thisType = Types.ignoreContext(thisType, BaseType.FormatType.RETURN);
                ArrayList<BaseType> allTypes = new ArrayList<BaseType>();
                ArrayList<TypeDecl> delegatedTypes = new ArrayList<TypeDecl>();
                for (TypeDecl typeDecl : this.convertibles.get((Object)classPath)) {
                    if (typeDecl.symbol == null) {
                        allTypes.add(typeDecl.type);
                        continue;
                    }
                    delegatedTypes.add(typeDecl);
                    allTypes.add(Types.primitive(typeDecl.symbol));
                }
                if (allTypes.isEmpty()) {
                    allTypes.add(thisType);
                }
                TypeDecl convertibleType = new TypeDecl((String)exportedSymbol, new JSJoinedType.Union(allTypes));
                TypeDecl globalType = new TypeDecl(symbol, exportedType);
                Wrapped.Global typeExport = new Wrapped.Global();
                typeExport.addCode(globalType);
                convertibleType.addComment("Class-specific type exported by ProbeJS, use global Type_\ntypes for convenience unless there's a naming conflict.\n");
                typeExport.addComment("Global type exported for convenience, use class-specific\ntypes if there's a naming conflict.\n");
                for (TypeDecl delegatedType : delegatedTypes) {
                    output.addCode(delegatedType);
                }
                output.addCode(convertibleType);
                output.addCode(typeExport);
                String fileKey = "%s.%s".formatted(classPath.parts().get(0), classPath.parts().get(1));
                BufferedWriter writer = files.computeIfAbsent(fileKey, key -> {
                    try {
                        return Files.newBufferedWriter(this.getPackageFolder().resolve(key + ".d.ts"), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        ProbeJS.LOGGER.error("Failed to write %s.d.ts".formatted(key));
                        return null;
                    }
                });
                if (writer != null) {
                    output.writeAsModule(writer);
                }
                ++this.dumped;
            }
            catch (Throwable t) {
                ProbeJS.LOGGER.error(t.getMessage());
                for (StackTraceElement stackTraceElement : t.getStackTrace()) {
                    ProbeJS.LOGGER.error(stackTraceElement.toString());
                }
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.getPackageFolder().resolve("index.d.ts"), new OpenOption[0]);){
            for (Map.Entry entry : files.entrySet()) {
                String key2 = (String)entry.getKey();
                BufferedWriter value = (BufferedWriter)entry.getValue();
                writer.write("/// <reference path=%s />\n".formatted(ProbeJS.GSON.toJson((Object)(key2 + ".d.ts"))));
                value.close();
            }
        }
    }

    public void dumpGlobal() throws IOException {
        ProbeJSPlugin.forEachPlugin(plugin -> plugin.addGlobals(this));
        try (BufferedWriter writer = Files.newBufferedWriter(this.getGlobalFolder().resolve("index.d.ts"), new OpenOption[0]);){
            for (Map.Entry<String, Pair<Collection<String>, Wrapped.Global>> entry : this.globals.entrySet()) {
                String identifier = entry.getKey();
                Pair<Collection<String>, Wrapped.Global> pair = entry.getValue();
                Wrapped.Global global = (Wrapped.Global)pair.getSecond();
                Collection excluded = (Collection)pair.getFirst();
                TypeScriptFile globalFile = new TypeScriptFile(null);
                for (String s : excluded) {
                    globalFile.excludeSymbol(s);
                }
                globalFile.addCode(global);
                globalFile.write(this.getGlobalFolder().resolve(identifier + ".d.ts"));
                writer.write("export * from %s\n".formatted(ProbeJS.GSON.toJson((Object)("./" + identifier))));
            }
        }
    }

    public void dumpJSConfig() throws IOException {
        FileUtils.writeMergedConfig(this.scriptPath.resolve("jsconfig.json"), "{\n    \"compilerOptions\": {\n        \"module\": \"commonjs\",\n        \"target\": \"ES2015\",\n        \"lib\": [\n            \"ES5\",\n            \"ES2015\"\n        ],\n        \"rootDir\": \".\",\n        \"typeRoots\": [\n            \"../../.probe/%s/probe-types\"\n        ],\n        \"baseUrl\": \"../../.probe/%s/probe-types\",\n        \"skipLibCheck\": true\n    },\n    \"include\": [\n        \"./**/*.js\",\n        \"./**/*.ts\",\n    ]\n}\n".formatted(this.basePath.getFileName(), this.basePath.getFileName()));
    }

    public void removeClasses() throws IOException {
        org.apache.commons.io.FileUtils.deleteDirectory((File)this.getTypeFolder().toFile());
    }

    public void dump() throws IOException, ClassNotFoundException {
        this.getSource();
        this.getTest();
        this.dumpClasses();
        this.dumpGlobal();
        this.dumpJSConfig();
    }

    private static void write(Path writeTo, String content) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(writeTo, new OpenOption[0]);){
            writer.write(content);
        }
    }
}

