/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.transpiler.transformation;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.java.clazz.Clazz;
import moe.wolfgirl.probejs.lang.transpiler.transformation.ClassTransformer;
import moe.wolfgirl.probejs.lang.typescript.Declaration;
import moe.wolfgirl.probejs.lang.typescript.code.Code;
import moe.wolfgirl.probejs.lang.typescript.code.member.ClassDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.MethodDecl;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import moe.wolfgirl.probejs.utils.NameUtils;

public class InjectBeans
implements ClassTransformer {
    @Override
    public void transform(Clazz clazz, ClassDecl classDecl) {
        HashSet<String> names = new HashSet<String>();
        for (MethodDecl method : classDecl.methods) {
            names.add(method.name);
        }
        for (MethodDecl method : classDecl.methods) {
            String beanName;
            if (method.isStatic) continue;
            if (method.name.startsWith("set") && method.params.size() == 1) {
                if (method.name.length() == 3 || names.contains(beanName = NameUtils.firstLower(method.name.substring(3)))) continue;
                classDecl.bodyCode.add(new BeanDecl("set %s(value: %s)", beanName, Types.ignoreContext(method.params.getFirst().type, BaseType.FormatType.INPUT)));
                continue;
            }
            if (!method.params.isEmpty()) continue;
            if (method.name.startsWith("get")) {
                if (method.name.length() == 3 || names.contains(beanName = NameUtils.firstLower(method.name.substring(3)))) continue;
                classDecl.bodyCode.add(new BeanDecl("get %s(): %s", beanName, method.returnType));
                continue;
            }
            if (!method.name.startsWith("is") || method.name.length() == 2 || names.contains(beanName = NameUtils.firstLower(method.name.substring(2)))) continue;
            classDecl.bodyCode.add(new BeanDecl("get %s(): %s", beanName, Types.BOOLEAN));
        }
    }

    public static class BeanDecl
    extends Code {
        public String formattingString;
        public String name;
        public BaseType baseType;

        BeanDecl(String formattingString, String name, BaseType baseType) {
            this.formattingString = formattingString;
            this.name = name;
            this.baseType = baseType;
        }

        @Override
        public Collection<ClassPath> getUsedClassPaths() {
            return this.baseType.getUsedClassPaths();
        }

        @Override
        public List<String> format(Declaration declaration) {
            return List.of(this.formattingString.formatted(ProbeJS.GSON.toJson((Object)this.name), this.baseType.line(declaration)));
        }
    }
}

