/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.transpiler.transformation;

import moe.wolfgirl.probejs.lang.java.clazz.Clazz;
import moe.wolfgirl.probejs.lang.java.clazz.members.ConstructorInfo;
import moe.wolfgirl.probejs.lang.java.clazz.members.FieldInfo;
import moe.wolfgirl.probejs.lang.java.clazz.members.MethodInfo;
import moe.wolfgirl.probejs.lang.transpiler.transformation.InjectAnnotation;
import moe.wolfgirl.probejs.lang.transpiler.transformation.InjectArray;
import moe.wolfgirl.probejs.lang.transpiler.transformation.InjectBeans;
import moe.wolfgirl.probejs.lang.transpiler.transformation.InjectSelf;
import moe.wolfgirl.probejs.lang.transpiler.transformation.InjectSpecialType;
import moe.wolfgirl.probejs.lang.typescript.code.member.ClassDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.ConstructorDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.FieldDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.MethodDecl;

public interface ClassTransformer {
    public static final ClassTransformer[] CLASS_TRANSFORMERS = new ClassTransformer[]{new InjectAnnotation(), new InjectArray(), new InjectBeans(), new InjectSelf(), new InjectSpecialType()};

    public static void transformClass(Clazz clazz, ClassDecl classDecl) {
        for (ClassTransformer classTransformer : CLASS_TRANSFORMERS) {
            classTransformer.transform(clazz, classDecl);
        }
    }

    public static void transformMethods(Clazz clazz, MethodInfo methodInfo, MethodDecl methodDecl) {
        for (ClassTransformer classTransformer : CLASS_TRANSFORMERS) {
            classTransformer.transformMethod(clazz, methodInfo, methodDecl);
        }
    }

    public static void transformConstructors(ConstructorInfo constructorInfo, ConstructorDecl constructorDecl) {
        for (ClassTransformer classTransformer : CLASS_TRANSFORMERS) {
            classTransformer.transformConstructor(constructorInfo, constructorDecl);
        }
    }

    public static void transformFields(FieldInfo fieldInfo, FieldDecl fieldDecl) {
        for (ClassTransformer classTransformer : CLASS_TRANSFORMERS) {
            classTransformer.transformField(fieldInfo, fieldDecl);
        }
    }

    default public void transform(Clazz clazz, ClassDecl classDecl) {
    }

    default public void transformMethod(Clazz clazz, MethodInfo methodInfo, MethodDecl methodDecl) {
    }

    default public void transformConstructor(ConstructorInfo constructorInfo, ConstructorDecl constructorDecl) {
    }

    default public void transformField(FieldInfo fieldInfo, FieldDecl fieldDecl) {
    }
}

