/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.transpiler;

import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.rhino.type.ArrayTypeInfo;
import dev.latvian.mods.rhino.type.ClassTypeInfo;
import dev.latvian.mods.rhino.type.JSFixedArrayTypeInfo;
import dev.latvian.mods.rhino.type.JSFunctionTypeInfo;
import dev.latvian.mods.rhino.type.JSObjectTypeInfo;
import dev.latvian.mods.rhino.type.JSOptionalParam;
import dev.latvian.mods.rhino.type.JSOrTypeInfo;
import dev.latvian.mods.rhino.type.ParameterizedTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.java.type.TypeDescriptor;
import moe.wolfgirl.probejs.lang.java.type.impl.ArrayType;
import moe.wolfgirl.probejs.lang.java.type.impl.ClassType;
import moe.wolfgirl.probejs.lang.java.type.impl.ParamType;
import moe.wolfgirl.probejs.lang.java.type.impl.VariableType;
import moe.wolfgirl.probejs.lang.java.type.impl.WildType;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSArrayType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSClassType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSParamType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSVariableType;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSArrayType;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSJoinedType;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSLambdaType;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSObjectType;

public class TypeConverter {
    public final Map<ClassPath, BaseType> predefinedTypes = new HashMap<ClassPath, BaseType>();
    public final ScriptManager scriptManager;

    public TypeConverter(ScriptManager manager) {
        this.scriptManager = manager;
    }

    public void addType(Class<?> clazz, BaseType type) {
        this.predefinedTypes.put(new ClassPath(clazz), type);
    }

    public BaseType convertType(TypeDescriptor descriptor) {
        if (descriptor instanceof ClassType) {
            ClassType classType = (ClassType)descriptor;
            return this.predefinedTypes.getOrDefault(classType.classPath, new TSClassType(classType.classPath));
        }
        if (descriptor instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)descriptor;
            return new TSArrayType(this.convertType(arrayType.component));
        }
        if (descriptor instanceof ParamType) {
            ParamType paramType = (ParamType)descriptor;
            BaseType base = this.convertType(paramType.base);
            if (base == Types.ANY) {
                return Types.ANY;
            }
            List<BaseType> params = paramType.params.stream().map(this::convertType).toList();
            return new TSParamType(base, params);
        }
        if (descriptor instanceof VariableType) {
            VariableType variableType = (VariableType)descriptor;
            List<TypeDescriptor> desc = variableType.descriptors;
            switch (desc.size()) {
                case 0: {
                    return new TSVariableType(variableType.symbol, null);
                }
                case 1: {
                    return new TSVariableType(variableType.symbol, this.convertType(desc.getFirst()));
                }
            }
            List<BaseType> converted = desc.stream().map(this::convertType).toList();
            return new TSVariableType(variableType.symbol, new JSJoinedType.Intersection(converted));
        }
        if (descriptor instanceof WildType) {
            WildType wildType = (WildType)descriptor;
            return wildType.stream().findAny().map(this::convertType).orElse(Types.ANY);
        }
        throw new RuntimeException("Unknown subclass of TypeDescriptor.");
    }

    public BaseType convertType(TypeInfo typeInfo) {
        return this.convertType(typeInfo, true);
    }

    public BaseType convertType(TypeInfo typeInfo, boolean baseType) {
        if (typeInfo == TypeInfo.NONE) {
            return Types.NEVER;
        }
        TypeInfo typeInfo2 = typeInfo;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JSObjectTypeInfo.class, ClassTypeInfo.class, ArrayTypeInfo.class, JSFixedArrayTypeInfo.class, JSFunctionTypeInfo.class, JSOrTypeInfo.class, ParameterizedTypeInfo.class}, (Object)typeInfo2, n)) {
            case 0 -> {
                JSObjectTypeInfo info = (JSObjectTypeInfo)typeInfo2;
                JSObjectType.Builder builder = Types.object();
                for (JSOptionalParam field : info.fields()) {
                    builder.member(field.name(), field.optional(), this.convertType(field.type()));
                }
                yield builder.build();
            }
            case 1 -> {
                ClassTypeInfo info = (ClassTypeInfo)typeInfo2;
                Class clazz = info.asClass();
                if (this.predefinedTypes.containsKey(new ClassPath(clazz))) {
                    yield this.predefinedTypes.get(new ClassPath(clazz));
                }
                if (clazz.getTypeParameters().length != 0 && !baseType) {
                    yield Types.parameterized(Types.type(clazz), (BaseType[])Collections.nCopies(clazz.getTypeParameters().length, Types.OBJECT).toArray(BaseType[]::new));
                }
                yield Types.type(clazz);
            }
            case 2 -> {
                ArrayTypeInfo info = (ArrayTypeInfo)typeInfo2;
                yield this.convertType(info.componentType()).asArray();
            }
            case 3 -> {
                JSFixedArrayTypeInfo info = (JSFixedArrayTypeInfo)typeInfo2;
                JSArrayType.Builder builder = Types.arrayOf();
                for (JSOptionalParam type : info.types()) {
                    builder.member(type.name(), type.optional(), this.convertType(type.type()));
                }
                yield builder.build();
            }
            case 4 -> {
                JSFunctionTypeInfo info = (JSFunctionTypeInfo)typeInfo2;
                JSLambdaType.Builder builder = Types.lambda().returnType(this.convertType(info.returnType()));
                for (JSOptionalParam param : info.params()) {
                    builder.param(param.name(), this.convertType(param.type()), param.optional());
                }
                yield builder.build();
            }
            case 5 -> {
                JSOrTypeInfo info = (JSOrTypeInfo)typeInfo2;
                yield Types.or((BaseType[])info.types().stream().map(this::convertType).toArray(BaseType[]::new));
            }
            case 6 -> {
                ParameterizedTypeInfo info = (ParameterizedTypeInfo)typeInfo2;
                if (info.rawType() == TypeInfo.RAW_OPTIONAL) {
                    yield Types.optional(this.convertType(info.param(0)));
                }
                BaseType[] params = (BaseType[])Arrays.stream(info.params()).map(p -> this.convertType((TypeInfo)p, false)).toArray(BaseType[]::new);
                yield Types.parameterized(this.convertType(info.rawType()), params);
            }
            default -> Types.ANY;
        };
    }
}

