/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.transformer;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ContextFactory;
import dev.latvian.mods.rhino.Parser;
import dev.latvian.mods.rhino.ast.AstNode;
import dev.latvian.mods.rhino.ast.AstRoot;
import dev.latvian.mods.rhino.ast.FunctionCall;
import dev.latvian.mods.rhino.ast.Name;
import dev.latvian.mods.rhino.ast.StringLiteral;
import dev.latvian.mods.rhino.ast.VariableDeclaration;
import dev.latvian.mods.rhino.ast.VariableInitializer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import moe.wolfgirl.probejs.ProbeConfig;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.utils.NameUtils;

public class KubeJSScript {
    private static final String PLACEHOLDER = "!@#$%^";
    private static final Supplier<Parser> PARSER = () -> {
        ContextFactory factory = new ContextFactory();
        Context context = factory.enter();
        return new Parser(context);
    };
    public final Set<String> exportedSymbols;
    public List<String> lines;

    public KubeJSScript(List<String> lines) {
        this.lines = new ArrayList<String>(lines);
        this.exportedSymbols = new HashSet<String>();
    }

    public void processRequire() {
        String joined = String.join((CharSequence)"\n", this.lines);
        AstRoot root = PARSER.get().parse(String.join((CharSequence)"\n", this.lines), "script.js", 0);
        ArrayList<Integer[]> cuts = new ArrayList<Integer[]>();
        for (AstNode statement : root.getStatements()) {
            if (!(statement instanceof VariableDeclaration)) continue;
            VariableDeclaration declaration = (VariableDeclaration)statement;
            List variables = declaration.getVariables();
            for (VariableInitializer variable : variables) {
                AstNode loaded;
                Name name;
                FunctionCall call;
                AstNode astNode = variable.getInitializer();
                if (!(astNode instanceof FunctionCall) || !((astNode = (call = (FunctionCall)astNode).getTarget()) instanceof Name) || !(name = (Name)astNode).getIdentifier().equals("require") || !((loaded = (AstNode)call.getArguments().getFirst()) instanceof StringLiteral)) continue;
                StringLiteral literal = (StringLiteral)loaded;
                if (literal.getValue().startsWith("packages/")) {
                    if (!declaration.isConst()) continue;
                    joined = NameUtils.replaceRegion(joined, statement.getPosition(), statement.getPosition() + statement.getLength(), "const ", PLACEHOLDER);
                    continue;
                }
                cuts.add(new Integer[]{statement.getPosition(), statement.getPosition() + statement.getLength()});
            }
        }
        cuts.sort(Comparator.comparing(p -> p[0]));
        joined = NameUtils.cutOffStartEnds(joined, cuts);
        joined = joined.replace(PLACEHOLDER, "let ");
        this.lines = new ArrayList<String>(List.of(joined.split("\\n")));
    }

    public void processExport() {
        for (int i = 0; i < this.lines.size(); ++i) {
            String tLine = this.lines.get(i).trim();
            if (tLine.startsWith("export")) {
                String identifier;
                tLine = tLine.substring(6).trim();
                String[] parts = tLine.split(" ", 2);
                switch (parts[0]) {
                    case "function": {
                        String string = parts[1].split("\\(")[0];
                        break;
                    }
                    case "var": 
                    case "let": 
                    case "const": {
                        String string = parts[1].split(" ")[0];
                        break;
                    }
                    default: {
                        String string = identifier = null;
                    }
                }
                if (identifier == null) continue;
                this.exportedSymbols.add(identifier);
            }
            this.lines.set(i, tLine);
        }
    }

    public void wrapScope() {
        String exported = this.exportedSymbols.stream().map(s -> "%s: %s".formatted(s, s)).collect(Collectors.joining(", "));
        String destructed = String.join((CharSequence)", ", this.exportedSymbols);
        this.lines.addFirst("const {%s} = (()=>{".formatted(destructed));
        this.lines.add("return {%s};})()".formatted(exported));
    }

    public String[] transform() {
        try {
            this.processExport();
            this.processRequire();
            if (ProbeConfig.INSTANCE.isolatedScopes.get().booleanValue() && !this.exportedSymbols.isEmpty()) {
                this.wrapScope();
            }
        }
        catch (Throwable t) {
            ProbeJS.LOGGER.info(t.getMessage());
        }
        return (String[])this.lines.toArray(String[]::new);
    }
}

