/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.snippet;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import moe.wolfgirl.probejs.lang.snippet.parts.Choice;
import moe.wolfgirl.probejs.lang.snippet.parts.Enumerable;
import moe.wolfgirl.probejs.lang.snippet.parts.Literal;
import moe.wolfgirl.probejs.lang.snippet.parts.SnippetPart;
import moe.wolfgirl.probejs.lang.snippet.parts.TabStop;
import moe.wolfgirl.probejs.lang.snippet.parts.Variable;
import moe.wolfgirl.probejs.utils.JsonUtils;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class Snippet {
    public final String name;
    final List<String> prefixes = new ArrayList<String>();
    final List<List<SnippetPart>> allParts = new ArrayList<List<SnippetPart>>();
    String description;

    public Snippet(String name) {
        this.name = name;
        this.allParts.add(new ArrayList());
    }

    public Snippet prefix(String prefix) {
        this.prefixes.add(prefix);
        return this;
    }

    public Snippet newline() {
        this.allParts.add(new ArrayList());
        return this;
    }

    public Snippet description(String description) {
        this.description = description;
        return this;
    }

    public Snippet literal(String content) {
        this.getRecent().add(new Literal(content));
        return this;
    }

    public Snippet tabStop() {
        return this.tabStop(-1);
    }

    public Snippet tabStop(int enumeration) {
        return this.tabStop(enumeration, null);
    }

    public Snippet tabStop(int enumeration, String defaultValue) {
        TabStop stop = new TabStop(defaultValue);
        stop.enumeration = enumeration;
        this.getRecent().add(stop);
        return this;
    }

    public Snippet choices(Collection<String> choices) {
        return this.choices(-1, choices);
    }

    public Snippet choices(int enumeration, Collection<String> choices) {
        Choice choice = new Choice(choices);
        choice.enumeration = enumeration;
        this.getRecent().add(choice);
        return this;
    }

    public Snippet variable(Variable variable) {
        this.getRecent().add(variable);
        return this;
    }

    public <T> Snippet registry(ResourceKey<Registry<T>> registry) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return this;
        }
        RegistryAccess.Frozen access = server.registryAccess();
        Registry reg = access.registry(registry).orElse(null);
        if (reg == null) {
            return this;
        }
        return this.choices(reg.keySet().stream().map(ResourceLocation::toString).collect(Collectors.toSet()));
    }

    private List<SnippetPart> getRecent() {
        return this.allParts.getLast();
    }

    public JsonObject compile() {
        IntArraySet indexes = new IntArraySet(256);
        ArrayList<Enumerable> toBeIndexed = new ArrayList<Enumerable>(64);
        for (List<SnippetPart> list : this.allParts) {
            for (SnippetPart snippetPart : list) {
                if (!(snippetPart instanceof Enumerable)) continue;
                Enumerable enumerable = (Enumerable)snippetPart;
                if (enumerable.enumeration == -1) {
                    toBeIndexed.add(enumerable);
                    continue;
                }
                indexes.add(enumerable.enumeration);
            }
        }
        int start = 1;
        for (Enumerable enumerable : toBeIndexed) {
            while (indexes.contains(start)) {
                ++start;
            }
            enumerable.enumeration = start++;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (List<SnippetPart> list : this.allParts) {
            StringBuilder content = new StringBuilder();
            for (SnippetPart part : list) {
                content.append(part.format());
            }
            arrayList.add(content.toString());
        }
        if (!indexes.contains(0)) {
            int n = arrayList.size() - 1;
            arrayList.set(n, (String)arrayList.get(n) + "$0");
        }
        JsonObject jsonObject = new JsonObject();
        if (this.prefixes.isEmpty()) {
            throw new RuntimeException("Must have at least one prefix for the snippet %s!".formatted(this.name));
        }
        jsonObject.add("prefix", (JsonElement)JsonUtils.asStringArray(this.prefixes));
        jsonObject.add("body", (JsonElement)JsonUtils.asStringArray(arrayList));
        if (this.description != null) {
            jsonObject.addProperty("description", this.description);
        }
        return jsonObject;
    }

    public List<String> getPrefixes() {
        return this.prefixes;
    }
}

