/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.schema;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.wolfgirl.probejs.lang.schema.ArrayElement;
import moe.wolfgirl.probejs.utils.JsonUtils;

public abstract class SchemaElement<T extends SchemaElement<T>> {
    protected final List<Object> enums = new ArrayList<Object>();
    protected final Map<String, Object> additional = new HashMap<String, Object>();

    public abstract String getType();

    protected abstract JsonObject toSchema();

    public JsonObject getSchema() {
        JsonObject object = this.toSchema();
        object.addProperty("type", this.getType());
        if (!this.enums.isEmpty()) {
            object.add("enum", JsonUtils.parseObject(this.enums));
        }
        for (Map.Entry<String, Object> entry : this.additional.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            JsonElement element = JsonUtils.parseObject(value);
            if (element == JsonNull.INSTANCE) continue;
            object.add(key, element);
        }
        return object;
    }

    protected final T self() {
        return (T)this;
    }

    public T enums(Object ... values) {
        this.enums.addAll(Arrays.asList(values));
        return this.self();
    }

    public T additionalField(String key, Object value) {
        this.additional.put(key, value);
        return this.self();
    }

    public ArrayElement asArray() {
        return new ArrayElement(this);
    }
}

