/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.schema;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.lang.schema.SchemaElement;
import moe.wolfgirl.probejs.plugin.ProbeJSPlugin;

public class SchemaDump {
    public Map<String, SchemaElement<?>> schemas = new HashMap();

    public void fromDocs() {
        ProbeJSPlugin.forEachPlugin(plugin -> plugin.addJsonSchema(this));
    }

    public void writeTo(Path path) throws IOException {
        for (Map.Entry<String, SchemaElement<?>> entry : this.schemas.entrySet()) {
            String key = entry.getKey();
            SchemaElement<?> content = entry.getValue();
            BufferedWriter writer = Files.newBufferedWriter(path.resolve(key + ".json"), new OpenOption[0]);
            try {
                JsonWriter jsonWriter = ProbeJS.GSON_WRITER.newJsonWriter((Writer)writer);
                jsonWriter.setIndent("    ");
                ProbeJS.GSON_WRITER.toJson((Object)content.getSchema(), JsonObject.class, jsonWriter);
            }
            finally {
                if (writer == null) continue;
                writer.close();
            }
        }
    }

    public void newSchema(String name, SchemaElement<?> element) {
        this.schemas.put(name, element);
    }
}

