/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.linter.rules;

import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.lang.linter.LintingWarning;
import moe.wolfgirl.probejs.lang.linter.rules.Rule;
import moe.wolfgirl.probejs.utils.NameUtils;

public class RespectPriority
extends Rule {
    private final Map<Path, ScriptFile> files = new HashMap<Path, ScriptFile>();

    @Override
    public void acceptFile(Path path, List<String> content) {
        int priority = 0;
        for (String s : content) {
            if (!(s = s.trim()).startsWith("//") || !s.contains("priority")) continue;
            try {
                priority = Integer.parseInt(s.split(":", 2)[1].trim());
                break;
            }
            catch (Throwable throwable) {
            }
        }
        ArrayList<Pair<Integer, Path>> depends = new ArrayList<Pair<Integer, Path>>();
        for (int i = 0; i < content.size(); ++i) {
            String dependsOn;
            Matcher matcher;
            String s = content.get(i).trim();
            if (s.endsWith(";")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.startsWith("import")) {
                matcher = NameUtils.MATCH_IMPORT.matcher(s);
                if (!matcher.matches() || (dependsOn = (String)ProbeJS.GSON.fromJson(matcher.group(2), String.class)).startsWith("package")) continue;
                depends.add((Pair<Integer, Path>)new Pair((Object)i, (Object)path.getParent().resolve(dependsOn + ".js").toAbsolutePath().normalize()));
                continue;
            }
            if (!s.contains("require") || !(matcher = NameUtils.MATCH_ANY_REQUIRE.matcher(s)).matches() || (dependsOn = (String)ProbeJS.GSON.fromJson(matcher.group(2), String.class)).startsWith("package")) continue;
            depends.add((Pair<Integer, Path>)new Pair((Object)i, (Object)path.getParent().resolve(dependsOn + ".js").toAbsolutePath().normalize()));
        }
        this.files.put(path, new ScriptFile(path, priority, content, depends));
    }

    @Override
    public List<LintingWarning> lint(Path basePath) {
        ArrayList<LintingWarning> warnings = new ArrayList<LintingWarning>();
        for (Map.Entry<Path, ScriptFile> entry : this.files.entrySet()) {
            Path path = entry.getKey();
            ScriptFile scriptFile = entry.getValue();
            for (Pair<Integer, Path> pair : scriptFile.dependencies) {
                int line = (Integer)pair.getFirst();
                Path dependency = (Path)pair.getSecond();
                ScriptFile dependencyFile = this.files.get(dependency);
                if (dependencyFile == null) {
                    ProbeJS.LOGGER.info((Object)path);
                    ProbeJS.LOGGER.info((Object)dependency);
                    ProbeJS.LOGGER.info(this.files);
                    warnings.add(new LintingWarning(path, LintingWarning.Level.WARNING, line, 0, "Unknown dependency: %s".formatted(basePath.relativize(dependency))));
                    continue;
                }
                if (!scriptFile.compareTo(dependencyFile)) continue;
                warnings.add(new LintingWarning(path, LintingWarning.Level.ERROR, line, 0, "Required %s before it loads!".formatted(basePath.relativize(dependency))));
            }
        }
        return warnings;
    }

    record ScriptFile(Path path, int priority, List<String> content, List<Pair<Integer, Path>> dependencies) {
        public boolean compareTo(ScriptFile o2) {
            int priority = -Integer.compare(this.priority, o2.priority);
            if (priority == 0) {
                priority = this.path.compareTo(o2.path);
            }
            return priority < 0;
        }
    }
}

