/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.java;

import dev.latvian.mods.rhino.util.HideFromJS;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.java.clazz.Clazz;
import moe.wolfgirl.probejs.lang.java.clazz.members.ConstructorInfo;
import moe.wolfgirl.probejs.lang.java.clazz.members.FieldInfo;
import moe.wolfgirl.probejs.lang.java.clazz.members.MethodInfo;
import moe.wolfgirl.probejs.lang.java.clazz.members.ParamInfo;
import moe.wolfgirl.probejs.lang.java.type.TypeDescriptor;
import moe.wolfgirl.probejs.lang.java.type.impl.VariableType;

@HideFromJS
public class ClassRegistry {
    public static final ClassRegistry REGISTRY = new ClassRegistry();
    public Map<ClassPath, Clazz> foundClasses = new HashMap<ClassPath, Clazz>();

    public void fromPackage(Collection<ClassPath> classPaths) {
        for (ClassPath pack : classPaths) {
            if (this.foundClasses.containsKey(pack)) continue;
            this.foundClasses.put(pack, pack.toClazz());
        }
    }

    public void fromClazz(Collection<Clazz> classes) {
        for (Clazz c : classes) {
            if (this.foundClasses.containsKey(c.classPath)) continue;
            this.foundClasses.put(c.classPath, c);
        }
    }

    public void fromClasses(Collection<Class<?>> classes) {
        for (Class<?> c : classes) {
            try {
                Class.forName(c.getName());
            }
            catch (Throwable ignore) {
                continue;
            }
            try {
                if (c.isSynthetic() || c.isAnonymousClass() || this.foundClasses.containsKey(new ClassPath(c))) continue;
                Clazz clazz = new Clazz(c);
                this.foundClasses.put(clazz.classPath, clazz);
            }
            catch (Throwable throwable) {}
        }
    }

    private Set<Class<?>> retrieveClass(Clazz clazz) {
        HashSet classes = new HashSet();
        for (ConstructorInfo constructor : clazz.constructors) {
            for (ParamInfo param : constructor.params) {
                classes.addAll(param.type.getClasses());
            }
            for (VariableType variableType : constructor.variableTypes) {
                classes.addAll(variableType.getClasses());
            }
        }
        for (MethodInfo method : clazz.methods) {
            for (ParamInfo param : method.params) {
                classes.addAll(param.type.getClasses());
            }
            for (VariableType variableType : method.variableTypes) {
                classes.addAll(variableType.getClasses());
            }
            classes.addAll(method.returnType.getClasses());
        }
        for (FieldInfo field : clazz.fields) {
            classes.addAll(field.type.getClasses());
        }
        for (VariableType variableType : clazz.variableTypes) {
            classes.addAll(variableType.getClasses());
        }
        if (clazz.superClass != null) {
            classes.addAll(clazz.superClass.getClasses());
        }
        for (TypeDescriptor i : clazz.interfaces) {
            classes.addAll(i.getClasses());
        }
        return classes;
    }

    public void discoverClasses() {
        HashSet<Clazz> currentClasses = new HashSet<Clazz>(this.foundClasses.values());
        while (!currentClasses.isEmpty()) {
            HashSet<Class> fetchedClass = new HashSet<Class>();
            for (Clazz currentClass : currentClasses) {
                fetchedClass.addAll(this.retrieveClass(currentClass));
            }
            fetchedClass.removeIf(clazz -> this.foundClasses.containsKey(new ClassPath((Class<?>)clazz)));
            currentClasses.clear();
            for (Class c : fetchedClass) {
                try {
                    Class.forName(c.getName());
                    Clazz clazz2 = new Clazz(c);
                    this.foundClasses.put(clazz2.classPath, clazz2);
                    currentClasses.add(clazz2);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public Collection<Clazz> getFoundClasses() {
        return this.foundClasses.values();
    }

    public void writeTo(Path path) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ClassPath classPath : this.foundClasses.keySet()) {
                writer.write(classPath.getClassPathJava() + "\n");
            }
        }
    }

    public void loadFrom(Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            for (String className : reader.lines()::iterator) {
                try {
                    Class<?> loaded = Class.forName(className);
                    this.fromClasses(Collections.singleton(loaded));
                }
                catch (Throwable throwable) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

