/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.decompiler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.lang.decompiler.ProbeClassScanner;
import moe.wolfgirl.probejs.lang.decompiler.ProbeClassSource;
import moe.wolfgirl.probejs.lang.decompiler.ProbeDecompilerLogger;
import moe.wolfgirl.probejs.lang.decompiler.ProbeFileSaver;
import net.neoforged.fml.ModList;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

public class ProbeDecompiler {
    public final ProbeFileSaver resultSaver = new ProbeFileSaver();
    public final ProbeClassScanner scanner = new ProbeClassScanner();

    public static List<File> findModFiles() {
        ModList modList = ModList.get();
        return modList.getModFiles().stream().map(fileInfo -> fileInfo.getFile().getFilePath()).map(Path::toFile).collect(Collectors.toList());
    }

    public void addRuntimeSource(File source) {
        try {
            this.scanner.acceptFile(source);
        }
        catch (IOException e) {
            ProbeJS.LOGGER.error("Unable to load file: %s".formatted(source));
        }
    }

    public void fromMods() {
        for (File modFile : ProbeDecompiler.findModFiles()) {
            this.addRuntimeSource(modFile);
        }
    }

    public void decompileContext() {
        Fernflower engine = new Fernflower((IResultSaver)this.resultSaver, Map.of(), (IFernflowerLogger)new ProbeDecompilerLogger());
        ProbeClassSource source = new ProbeClassSource(this.scanner.getScannedClasses());
        engine.addSource((IContextSource)source);
        this.resultSaver.classCount = 0;
        try {
            engine.decompileContext();
        }
        finally {
            engine.clearContext();
        }
    }
}

