/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.decompiler;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ProbeClassScanner {
    private final Set<Class<?>> scannedClasses = new HashSet();

    public void acceptFile(File file) throws IOException {
        try (ZipFile jarFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(".class")) continue;
                name = name.substring(0, name.length() - ".class".length());
                name = name.replace("/", ".");
                try {
                    if (name.contains("com.mojang.blaze3d.systems.TimerQuery")) continue;
                    this.scannedClasses.add(Class.forName(name));
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public Set<Class<?>> getScannedClasses() {
        return this.scannedClasses;
    }
}

