/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.features.schema;

import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.recipe.schema.UnknownRecipeSchemaType;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import moe.wolfgirl.probejs.utils.GameUtils;

public class SchemaDownloader {
    private static final String GAME_VERSION = "1.21";
    private static final String BASE_URL = "https://github.com/Prunoideae/-recipes/zipball/%s";
    private final Set<String> unsupportedRecipes = new HashSet<String>();

    public SchemaDownloader() {
        ServerScriptManager manager = GameUtils.getServerScriptManager();
        if (manager == null) {
            return;
        }
        for (Map.Entry entry : manager.recipeSchemaStorage.namespaces.entrySet()) {
            String namespace = (String)entry.getKey();
            RecipeNamespace rn = (RecipeNamespace)entry.getValue();
            for (Map.Entry e : rn.entrySet()) {
                String id = (String)e.getKey();
                RecipeSchemaType schema = (RecipeSchemaType)e.getValue();
                if (!(schema instanceof UnknownRecipeSchemaType)) continue;
                this.unsupportedRecipes.add("%s:%s".formatted(namespace, id));
            }
        }
    }

    public ZipInputStream openSchemaStream() throws URISyntaxException, IOException {
        String downloadUrl = BASE_URL.formatted(GAME_VERSION);
        URL url = new URI(downloadUrl).toURL();
        URLConnection connection = url.openConnection();
        return new ZipInputStream(connection.getInputStream());
    }

    public void processFile(ZipInputStream inputStream) throws IOException {
        ZipEntry entry = inputStream.getNextEntry();
        while (entry != null) {
            String[] parts;
            String fileName;
            if (!entry.isDirectory() && (fileName = entry.getName()).endsWith(".json") && (parts = (fileName = fileName.substring(0, fileName.length() - 5)).split("/")).length >= 2) {
                String namespace = parts[parts.length - 2];
                String recipe = parts[parts.length - 1];
                if (this.unsupportedRecipes.contains("%s:%s".formatted(namespace, recipe))) {
                    Path schemaJson = this.validateSchemaPath(namespace, recipe);
                    try (BufferedOutputStream writer = new BufferedOutputStream(Files.newOutputStream(schemaJson, new OpenOption[0]));){
                        writer.write(inputStream.readAllBytes());
                    }
                }
            }
            entry = inputStream.getNextEntry();
        }
    }

    public Path validateSchemaPath(String namespace, String recipe) throws IOException {
        Path dirPath = KubeJSPaths.DATA.resolve("%s/kubejs/recipe_schemas".formatted(namespace));
        if (!Files.exists(dirPath, new LinkOption[0])) {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        return dirPath.resolve("%s.json".formatted(recipe));
    }
}

