/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.features.interop;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.stream.Stream;
import moe.wolfgirl.probejs.features.bridge.Command;
import moe.wolfgirl.probejs.utils.RegistryUtils;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public abstract class ListRegistryCommand
extends Command {
    protected abstract Stream<ResourceLocation> getItems(Registry<?> var1);

    @Override
    public JsonElement handle(JsonObject payload) {
        String registryKey = payload.get("registry").getAsString();
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            return new JsonArray();
        }
        RegistryAccess.Frozen access = currentServer.registryAccess();
        for (ResourceKey<? extends Registry<?>> resourceKey : RegistryUtils.getRegistries((RegistryAccess)access)) {
            String registryName = resourceKey.location().getNamespace().equals("minecraft") ? resourceKey.location().getPath() : resourceKey.location().toString();
            if (!registryKey.equals(registryName)) continue;
            Registry registry = access.registry(resourceKey).orElse(null);
            if (registry == null) break;
            JsonArray result = new JsonArray();
            this.getItems(registry).map(ResourceLocation::toString).map(JsonPrimitive::new).forEach(arg_0 -> ((JsonArray)result).add(arg_0));
            return result;
        }
        return new JsonArray();
    }

    public static class Tags
    extends ListRegistryCommand {
        @Override
        public String identifier() {
            return "list_registry_tags";
        }

        @Override
        protected Stream<ResourceLocation> getItems(Registry<?> registry) {
            return registry.getTagNames().map(TagKey::location);
        }
    }

    public static class Objects
    extends ListRegistryCommand {
        @Override
        public String identifier() {
            return "list_registry_items";
        }

        @Override
        protected Stream<ResourceLocation> getItems(Registry<?> registry) {
            return registry.keySet().stream();
        }
    }
}

