/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.features.bridge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.features.bridge.Command;
import moe.wolfgirl.probejs.features.bridge.PingCommand;
import moe.wolfgirl.probejs.features.interop.EvaluateCommand;
import moe.wolfgirl.probejs.features.interop.LintCommand;
import moe.wolfgirl.probejs.features.interop.ListRegistryCommand;
import moe.wolfgirl.probejs.features.interop.ReloadCommand;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class ProbeServer
extends WebSocketServer {
    public static final Command[] REGISTRY = new Command[]{new PingCommand(), new LintCommand(), new ListRegistryCommand.Objects(), new ListRegistryCommand.Tags(), new ReloadCommand(), new EvaluateCommand()};
    private final Map<String, Command> dispatcher = new HashMap<String, Command>();

    public ProbeServer(int port) throws UnknownHostException {
        super(new InetSocketAddress(Inet4Address.getByName("127.0.0.1"), port));
        for (Command command : REGISTRY) {
            this.dispatcher.put(command.identifier(), command);
        }
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
    }

    public void onMessage(WebSocket conn, String message) {
        Command.Payload payload = (Command.Payload)ProbeJS.GSON.fromJson(message, Command.Payload.class);
        Command handler = this.dispatcher.get(payload.command());
        if (handler == null) {
            return;
        }
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            return;
        }
        currentServer.execute(() -> {
            JsonObject response = new JsonObject();
            response.addProperty("id", payload.id());
            try {
                response.add("payload", handler.handle(payload.payload()));
            }
            catch (Throwable throwable) {
                response.addProperty("error", throwable.getMessage());
            }
            ProbeJS.LOGGER.info((Object)response);
            conn.send(ProbeJS.GSON.toJson((JsonElement)response));
        });
    }

    public void onError(WebSocket conn, Exception ex) {
    }

    public void onStart() {
    }

    public void broadcast(String event, JsonElement payload) {
        JsonObject pack = new JsonObject();
        pack.addProperty("event", event);
        pack.add("payload", payload);
        this.broadcast(ProbeJS.GSON.toJson((JsonElement)pack));
    }
}

