/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.docs.events;

import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.tag.TagKubeEvent;
import dev.latvian.mods.kubejs.server.tag.TagWrapper;
import java.util.Map;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.typescript.ScriptDump;
import moe.wolfgirl.probejs.lang.typescript.TypeScriptFile;
import moe.wolfgirl.probejs.lang.typescript.code.member.ClassDecl;
import moe.wolfgirl.probejs.lang.typescript.code.ts.MethodDeclaration;
import moe.wolfgirl.probejs.lang.typescript.code.ts.Statements;
import moe.wolfgirl.probejs.lang.typescript.code.ts.Wrapped;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSClassType;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import moe.wolfgirl.probejs.plugin.ProbeJSPlugin;
import moe.wolfgirl.probejs.utils.NameUtils;
import moe.wolfgirl.probejs.utils.RegistryUtils;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class TagEvents
extends ProbeJSPlugin {
    public static final ClassPath TAG_EVENT = new ClassPath("moe.wolfgirl.probejs.generated.TagEventProbe");
    public static final ClassPath TAG_WRAPPER = new ClassPath("moe.wolfgirl.probejs.generated.TagWrapperProbe");

    @Override
    public void addGlobals(ScriptDump scriptDump) {
        if (scriptDump.scriptType != ScriptType.SERVER) {
            return;
        }
        TSClassType eventType = Types.type(TAG_EVENT);
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            return;
        }
        RegistryAccess.Frozen registryAccess = currentServer.registryAccess();
        Wrapped.Namespace groupNamespace = new Wrapped.Namespace("ServerEvents");
        for (ResourceKey<? extends Registry<?>> resourceKey : RegistryUtils.getRegistries((RegistryAccess)registryAccess)) {
            Registry registry = registryAccess.registry(resourceKey).orElse(null);
            if (registry == null) continue;
            String typeName = "Special." + NameUtils.rlToTitle(resourceKey.location().getPath());
            String tagName = typeName + "Tag";
            String extraName = resourceKey.location().getNamespace().equals("minecraft") ? resourceKey.location().getPath() : resourceKey.location().toString();
            MethodDeclaration declaration = Statements.method("tags").param("extra", Types.literal(extraName)).param("handler", Types.lambda().param("event", Types.parameterized(eventType, Types.primitive(tagName), Types.primitive(typeName))).build()).build();
            groupNamespace.addCode(declaration);
        }
        scriptDump.addGlobal("tag_events", groupNamespace);
    }

    @Override
    public void modifyClasses(ScriptDump scriptDump, Map<ClassPath, TypeScriptFile> globalClasses) {
        if (scriptDump.scriptType != ScriptType.SERVER) {
            return;
        }
        TSClassType wrapperType = Types.type(TAG_WRAPPER);
        ClassDecl tagEventProbe = Statements.clazz(TAG_EVENT.getName()).superClass(Types.type(TagKubeEvent.class)).typeVariables("T", "I").method("add", builder -> builder.returnType(Types.parameterized(wrapperType, Types.generic("T"), Types.generic("I"))).param("tag", Types.generic("T")).param("filters", Types.generic("I").asArray(), false, true)).method("remove", builder -> builder.returnType(Types.parameterized(wrapperType, Types.generic("T"), Types.generic("I"))).param("tag", Types.generic("T")).param("filters", Types.generic("I").asArray(), false, true)).build();
        TypeScriptFile eventFile = new TypeScriptFile(TAG_EVENT);
        eventFile.addCode(tagEventProbe);
        globalClasses.put(TAG_EVENT, eventFile);
        ClassDecl tagWrapperProbe = Statements.clazz(TAG_WRAPPER.getName()).superClass(Types.type(TagWrapper.class)).typeVariables("T", "I").method("add", builder -> builder.returnType(Types.THIS).param("filters", Types.generic("I").asArray(), false, true)).method("remove", builder -> builder.returnType(Types.THIS).param("filters", Types.generic("I").asArray(), false, true)).build();
        TypeScriptFile wrapperFile = new TypeScriptFile(TAG_WRAPPER);
        wrapperFile.addCode(tagWrapperProbe);
        globalClasses.put(TAG_WRAPPER, wrapperFile);
    }
}

