/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.docs.events;

import dev.latvian.mods.kubejs.registry.BuilderType;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.registry.RegistryKubeEvent;
import dev.latvian.mods.kubejs.registry.RegistryType;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.typescript.ScriptDump;
import moe.wolfgirl.probejs.lang.typescript.TypeScriptFile;
import moe.wolfgirl.probejs.lang.typescript.code.member.ClassDecl;
import moe.wolfgirl.probejs.lang.typescript.code.ts.MethodDeclaration;
import moe.wolfgirl.probejs.lang.typescript.code.ts.Statements;
import moe.wolfgirl.probejs.lang.typescript.code.ts.Wrapped;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import moe.wolfgirl.probejs.plugin.ProbeJSPlugin;
import moe.wolfgirl.probejs.utils.NameUtils;
import moe.wolfgirl.probejs.utils.RegistryUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;

public class RegistryEvents
extends ProbeJSPlugin {
    @Override
    public void addGlobals(ScriptDump scriptDump) {
        if (scriptDump.scriptType != ScriptType.STARTUP) {
            return;
        }
        Wrapped.Namespace groupNamespace = new Wrapped.Namespace("StartupEvents");
        for (ResourceKey key : BuiltInRegistries.REGISTRY.registryKeySet()) {
            ClassPath registryPath = RegistryEvents.getRegistryClassPath(key.location().getNamespace(), key.location().getPath());
            String extraName = key.location().getNamespace().equals("minecraft") ? key.location().getPath() : key.location().toString();
            MethodDeclaration declaration = Statements.method("registry").param("type", Types.literal(extraName)).param("handler", Types.lambda().param("event", Types.type(registryPath)).build()).build();
            groupNamespace.addCode(declaration);
        }
        scriptDump.addGlobal("registry_events", groupNamespace);
    }

    @Override
    public void modifyClasses(ScriptDump scriptDump, Map<ClassPath, TypeScriptFile> globalClasses) {
        if (scriptDump.scriptType != ScriptType.STARTUP) {
            return;
        }
        for (ResourceKey key : BuiltInRegistries.REGISTRY.registryKeySet()) {
            RegistryInfo info = RegistryInfo.of(RegistryUtils.castKey(key));
            RegistryType type = RegistryType.ofKey((ResourceKey)key);
            if (type == null) continue;
            ClassPath registryPath = RegistryEvents.getRegistryClassPath(key.location().getNamespace(), key.location().getPath());
            ClassDecl registryClass = RegistryEvents.generateRegistryClass(key, type.baseClass(), info);
            TypeScriptFile registryFile = new TypeScriptFile(registryPath);
            registryFile.addCode(registryClass);
            globalClasses.put(registryPath, registryFile);
        }
        TypeScriptFile registryEvent = globalClasses.get(new ClassPath(RegistryKubeEvent.class));
        ClassDecl eventClass = registryEvent.findCode(ClassDecl.class).orElse(null);
        if (eventClass == null) {
            return;
        }
        eventClass.methods.stream().filter(method -> method.name.equals("createCustom") && method.params.size() == 2).findAny().ifPresent(method -> {
            method.params.get((int)1).type = Types.lambda().returnType(Types.generic("T")).build();
        });
    }

    private static ClassPath getRegistryClassPath(String namespace, String location) {
        return new ClassPath("moe.wolfgirl.probejs.generated.registry.%s.%s".formatted(namespace, NameUtils.rlToTitle(location)));
    }

    private static ClassDecl generateRegistryClass(ResourceKey<?> key, Class<?> baseClass, RegistryInfo<?> info) {
        ClassDecl.Builder builder = Statements.clazz(NameUtils.rlToTitle(key.location().getPath())).superClass(Types.parameterized(Types.type(RegistryKubeEvent.class), Types.type(baseClass)));
        BuilderType defaultType = info.getDefaultType();
        if (defaultType != null) {
            builder.method("create", method -> method.returnType(Types.typeMaybeGeneric(defaultType.builderClass())).param("name", Types.STRING));
        }
        for (BuilderType type : info.getTypes()) {
            builder.method("create", method -> method.returnType(Types.typeMaybeGeneric(type.builderClass())).param("name", Types.STRING).param("type", Types.literal(type.type())));
        }
        return builder.build();
    }

    @Override
    public Set<Class<?>> provideJavaClass(ScriptDump scriptDump) {
        HashSet classes = new HashSet();
        for (ResourceKey key : BuiltInRegistries.REGISTRY.registryKeySet()) {
            RegistryInfo registryInfo = RegistryInfo.of(RegistryUtils.castKey(key));
            BuilderType defaultType = registryInfo.getDefaultType();
            if (defaultType != null) {
                classes.add(defaultType.builderClass());
            }
            for (BuilderType type : registryInfo.getTypes()) {
                classes.add(type.builderClass());
            }
        }
        return classes;
    }
}

