/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.docs.assignments;

import dev.latvian.mods.rhino.type.ParameterizedTypeInfo;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.java.clazz.Clazz;
import moe.wolfgirl.probejs.lang.transpiler.TypeConverter;
import moe.wolfgirl.probejs.lang.transpiler.transformation.InjectSpecialType;
import moe.wolfgirl.probejs.lang.typescript.ScriptDump;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSParamType;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSArrayType;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSObjectType;
import moe.wolfgirl.probejs.plugin.ProbeJSPlugin;

public class RecordTypes
extends ProbeJSPlugin {
    @Override
    public void assignType(ScriptDump scriptDump) {
        TypeConverter converter = scriptDump.transpiler.typeConverter;
        for (Clazz recordedClass : scriptDump.recordedClasses) {
            if (!recordedClass.original.isRecord()) continue;
            RecordTypeInfo typeWrapper = (RecordTypeInfo)TypeInfo.of(recordedClass.original);
            JSObjectType.Builder objectType = Types.object();
            JSArrayType.Builder arrayType = Types.arrayOf();
            for (RecordTypeInfo.Component component : typeWrapper.recordComponents().values()) {
                ParameterizedTypeInfo parameterizedTypeInfo;
                BaseType type = converter.convertType(component.type());
                TypeInfo typeInfo = component.type();
                if (typeInfo instanceof ParameterizedTypeInfo && InjectSpecialType.NO_WRAPPING.contains(new ClassPath((parameterizedTypeInfo = (ParameterizedTypeInfo)typeInfo).rawType().asClass())) && type instanceof TSParamType) {
                    TSParamType paramType = (TSParamType)type;
                    paramType.params.replaceAll(baseType -> Types.ignoreContext(baseType, BaseType.FormatType.RETURN));
                }
                objectType.member(component.name(), true, type);
                arrayType.member(component.name(), true, type);
            }
            scriptDump.assignType(recordedClass.classPath, (BaseType)objectType.build());
            scriptDump.assignType(recordedClass.classPath, (BaseType)arrayType.build());
        }
    }
}

