/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.latvian.mods.kubejs.KubeJS;
import java.net.UnknownHostException;
import java.util.function.Consumer;
import moe.wolfgirl.probejs.GlobalStates;
import moe.wolfgirl.probejs.ProbeConfig;
import moe.wolfgirl.probejs.ProbeDump;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.features.bridge.ProbeServer;
import moe.wolfgirl.probejs.lang.linter.Linter;
import moe.wolfgirl.probejs.utils.GameUtils;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class GameEvents {
    private static final int MOD_LIMIT = 350;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void playerJoined(ClientPlayerNetworkEvent.LoggingIn event) {
        LocalPlayer player = event.getPlayer();
        ProbeConfig config = ProbeConfig.INSTANCE;
        if (config.enabled.get().booleanValue()) {
            if (config.modHash.get() == -1L) {
                player.sendSystemMessage((Component)Component.translatable((String)"probejs.hello").kjs$gold());
            }
            if (config.registryHash.get() != GameUtils.registryHash()) {
                new Thread(() -> {
                    ProbeDump dump = new ProbeDump();
                    dump.defaultScripts();
                    try {
                        dump.trigger(arg_0 -> ((LocalPlayer)player).sendSystemMessage(arg_0));
                        Linter.defaultLint(arg_0 -> ((LocalPlayer)player).sendSystemMessage(arg_0));
                    }
                    catch (Throwable e) {
                        ProbeJS.LOGGER.error(e.getMessage());
                        for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                            ProbeJS.LOGGER.error(stackTraceElement.toString());
                        }
                        throw new RuntimeException(e);
                    }
                }).start();
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"probejs.enabled_warning").append((Component)Component.literal((String)"/probejs disable").kjs$clickSuggestCommand("/probejs disable").kjs$aqua()));
                if (ModList.get().size() >= 350 && ProbeConfig.INSTANCE.complete.get().booleanValue()) {
                    player.sendSystemMessage((Component)Component.translatable((String)"probejs.performance", (Object[])new Object[]{ModList.get().size()}));
                }
                Linter.defaultLint(arg_0 -> ((LocalPlayer)player).sendSystemMessage(arg_0));
            }
            player.sendSystemMessage((Component)Component.translatable((String)"probejs.wiki").append((Component)Component.literal((String)"Wiki Page").kjs$aqua().kjs$underlined().kjs$clickOpenUrl("https://kubejs.com/wiki/addons/third-party/probejs").kjs$hover((Component)Component.literal((String)"https://kubejs.com/wiki/addons/third-party/probejs"))));
            if (config.interactive.get().booleanValue() && GlobalStates.SERVER == null) {
                try {
                    GlobalStates.SERVER = new ProbeServer(config.interactivePort.get());
                    GlobalStates.SERVER.start();
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
                player.sendSystemMessage((Component)Component.translatable((String)"probejs.interactive", (Object[])new Object[]{config.interactivePort.get()}));
            }
        }
    }

    @SubscribeEvent
    public static void registerCommand(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"probejs").then(((LiteralArgumentBuilder)Commands.literal((String)"dump").requires(source -> ProbeConfig.INSTANCE.enabled.get() != false && source.hasPermission(2))).executes(context -> {
            KubeJS.PROXY.reloadClientInternal();
            ProbeDump dump = new ProbeDump();
            dump.defaultScripts();
            new Thread(() -> {
                try {
                    Consumer<Component> reportProgress = component -> ((CommandSourceStack)context.getSource()).sendSystemMessage(component);
                    dump.trigger(reportProgress);
                }
                catch (Throwable e) {
                    ProbeJS.LOGGER.error(e.getMessage());
                    for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                        ProbeJS.LOGGER.error(stackTraceElement.toString());
                    }
                    throw new RuntimeException(e);
                }
            }).start();
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"disable").requires(source -> ProbeConfig.INSTANCE.enabled.get() != false && source.hasPermission(2))).executes(context -> {
            ProbeConfig.INSTANCE.enabled.set(false);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"probejs.bye_bye").kjs$gold());
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"enable").requires(source -> source.hasPermission(2))).executes(context -> {
            ProbeConfig.INSTANCE.enabled.set(true);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"probejs.hello_again").kjs$aqua());
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"scope_isolation").requires(source -> ProbeConfig.INSTANCE.enabled.get() != false && source.hasPermission(2))).executes(context -> {
            boolean flag = ProbeConfig.INSTANCE.isolatedScopes.get() == false;
            ProbeConfig.INSTANCE.isolatedScopes.set(flag);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)(flag ? Component.translatable((String)"probejs.isolation").kjs$aqua() : Component.translatable((String)"probejs.no_isolation").kjs$aqua()));
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"lint").requires(source -> ProbeConfig.INSTANCE.enabled.get() != false && source.hasPermission(2))).executes(context -> {
            Linter.defaultLint(arg_0 -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).sendSystemMessage(arg_0));
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"complete_dump").requires(source -> ProbeConfig.INSTANCE.enabled.get() != false && source.hasPermission(2))).executes(context -> {
            boolean flag = ProbeConfig.INSTANCE.complete.get() == false;
            ProbeConfig.INSTANCE.complete.set(flag);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)(flag ? Component.translatable((String)"probejs.complete") : Component.translatable((String)"probejs.no_complete")));
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"decompile").requires(source -> ProbeConfig.INSTANCE.enabled.get() != false && source.hasPermission(2))).executes(context -> {
            boolean flag = ProbeConfig.INSTANCE.enableDecompiler.get() == false;
            ProbeConfig.INSTANCE.enableDecompiler.set(flag);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)(flag ? Component.translatable((String)"probejs.decompile") : Component.translatable((String)"probejs.no_decompile")));
            if (flag) {
                ProbeConfig.INSTANCE.modHash.set(-2L);
            }
            return 1;
        })));
    }

    @SubscribeEvent
    public static void rightClickedBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getSide() == LogicalSide.SERVER) {
            GlobalStates.LAST_RIGHTCLICKED = event.getPos();
        }
    }

    @SubscribeEvent
    public static void rightClickedEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getSide() == LogicalSide.SERVER) {
            GlobalStates.LAST_ENTITY = event.getTarget();
        }
    }

    @SubscribeEvent
    public static void changedDimension(EntityTravelToDimensionEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && !((player = (Player)entity) instanceof FakePlayer)) {
            GlobalStates.LAST_RIGHTCLICKED = null;
            GlobalStates.LAST_ENTITY = null;
        }
    }
}

