/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.prefab.TileEntityInternalMultiblock;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Clearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityTurbineRotor
extends TileEntityInternalMultiblock
implements Clearable {
    public int blades = 0;
    private int position = -1;
    private int radius = -1;
    public float rotationLower;
    public float rotationUpper;

    public TileEntityTurbineRotor(BlockPos pos, BlockState state) {
        super(GeneratorsBlocks.TURBINE_ROTOR, pos, state);
    }

    public void onNeighborChange(Block block, BlockPos neighborPos) {
        super.onNeighborChange(block, neighborPos);
        if (!this.isRemote()) {
            this.updateRotors();
        }
    }

    public void updateRotors() {
        TileEntityTurbineRotor rotor = this.getRotor(this.getBlockPos().below());
        if (rotor == null) {
            this.scanRotors(0);
        } else {
            rotor.updateRotors();
        }
    }

    private void scanRotors(int index) {
        TileEntityTurbineRotor rotor;
        if (index != this.position) {
            this.position = index;
            this.updateRadius();
            if (this.blades > 0) {
                this.sendUpdatePacket();
            }
        }
        if ((rotor = this.getRotor(this.getBlockPos().above())) != null) {
            rotor.scanRotors(index + 1);
        }
    }

    public boolean addBlade(boolean checkBelow) {
        TileEntityTurbineRotor previous;
        if (checkBelow && (previous = this.getRotor(this.getBlockPos().below())) != null && previous.blades < 2) {
            return previous.addBlade(true);
        }
        if (this.blades < 2) {
            ++this.blades;
            if (this.position == -1) {
                this.scanRotors(0);
            } else {
                MultiblockData multiblockData;
                if (this.hasFormedMultiblock() && (multiblockData = this.getMultiblock()) instanceof TurbineMultiblockData) {
                    TurbineMultiblockData multiblock = (TurbineMultiblockData)multiblockData;
                    ++multiblock.blades;
                }
                this.sendUpdatePacket();
            }
            return true;
        }
        TileEntityTurbineRotor next = this.getRotor(this.getBlockPos().above());
        return next != null && next.addBlade(false);
    }

    public boolean removeBlade() {
        TileEntityTurbineRotor next = this.getRotor(this.getBlockPos().above());
        if (next != null && next.blades > 0) {
            return next.removeBlade();
        }
        if (this.blades > 0) {
            MultiblockData multiblockData;
            --this.blades;
            if (this.hasFormedMultiblock() && (multiblockData = this.getMultiblock()) instanceof TurbineMultiblockData) {
                TurbineMultiblockData multiblock = (TurbineMultiblockData)multiblockData;
                --multiblock.blades;
            }
            this.sendUpdatePacket();
            return true;
        }
        next = this.getRotor(this.getBlockPos().below());
        return next != null && next.removeBlade();
    }

    public void clearContent() {
        this.blades = 0;
    }

    public int getHousedBlades() {
        return this.blades;
    }

    public int getPosition() {
        return this.position;
    }

    private void updateRadius() {
        this.radius = 1 + this.position / 4;
    }

    public int getRadius() {
        return this.radius;
    }

    @Nullable
    private TileEntityTurbineRotor getRotor(BlockPos pos) {
        return (TileEntityTurbineRotor)WorldUtils.getTileEntity(TileEntityTurbineRotor.class, (BlockGetter)this.getLevel(), (BlockPos)pos);
    }

    public void blockRemoved() {
        int amount;
        super.blockRemoved();
        if (!this.isRemote() && (amount = this.getHousedBlades()) > 0) {
            Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)GeneratorsItems.TURBINE_BLADE.getItemStack(amount));
        }
    }

    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.blades = nbt.getInt("blades");
        this.position = nbt.getInt("position");
        this.updateRadius();
    }

    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putInt("blades", this.getHousedBlades());
        nbtTags.putInt("position", this.getPosition());
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.putInt("blades", this.blades);
        updateTag.putInt("position", this.position);
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        int prevBlades = this.blades;
        int prevPosition = this.position;
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"blades", value -> {
            this.blades = value;
        });
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"position", value -> {
            this.position = value;
            this.updateRadius();
        });
        if (prevBlades != this.blades || prevPosition != prevBlades) {
            this.rotationLower = 0.0f;
            this.rotationUpper = 0.0f;
        }
    }
}

