/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityWindGenerator
extends TileEntityGenerator
implements IBoundingBlock {
    private static final float SPEED = 32.0f;
    private double angle;
    private FloatingLong currentMultiplier = FloatingLong.ZERO;
    private boolean isBlacklistDimension;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy item slot")
    EnergyInventorySlot energySlot;

    public TileEntityWindGenerator(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.WIND_GENERATOR, pos, state, (FloatingLongSupplier)MekanismGeneratorsConfig.generators.windGenerationMax);
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityWindGenerator)this).getDirection());
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    @Override
    protected RelativeSide[] getEnergySides() {
        return new RelativeSide[]{RelativeSide.FRONT, RelativeSide.BOTTOM};
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.drainContainer();
        if (this.isBlacklistDimension) {
            return sendUpdatePacket;
        }
        if (this.ticker % 20 == 0) {
            this.currentMultiplier = this.getMultiplier();
            this.setActive(this.canFunction() && !this.currentMultiplier.isZero());
        }
        if (!this.currentMultiplier.isZero() && this.canFunction() && !this.getEnergyContainer().getNeeded().isZero()) {
            this.getEnergyContainer().insert(((FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMin.get()).multiply(this.currentMultiplier), Action.EXECUTE, AutomationType.INTERNAL);
        }
        return sendUpdatePacket;
    }

    protected void onUpdateClient() {
        super.onUpdateClient();
        if (this.getActive()) {
            this.angle = (this.angle + (double)this.getHeightSpeedRatio()) % 360.0;
        }
    }

    public float getHeightSpeedRatio() {
        int height = this.getBlockPos().getY() + 4;
        if (this.level == null) {
            return 32.0f * (float)height / 384.0f;
        }
        int minBuildHeight = this.level.getMinBuildHeight();
        return 32.0f * (float)(height -= minBuildHeight) / (float)(this.level.getMaxBuildHeight() - minBuildHeight);
    }

    private FloatingLong getMultiplier() {
        BlockPos top;
        if (this.level != null && this.level.getFluidState(top = this.getBlockPos().above(4)).isEmpty() && this.level.canSeeSky(top)) {
            int minY = Math.max(MekanismGeneratorsConfig.generators.windGenerationMinY.get(), this.level.getMinBuildHeight());
            int maxY = Math.min(MekanismGeneratorsConfig.generators.windGenerationMaxY.get(), this.level.dimensionType().logicalHeight());
            float clampedY = Math.min(maxY, Math.max(minY, top.getY()));
            FloatingLong minG = (FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMin.get();
            FloatingLong maxG = (FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMax.get();
            FloatingLong slope = maxG.subtract(minG).divide((long)(maxY - minY));
            FloatingLong toGen = minG.add(slope.multiply((double)(clampedY - (float)minY)));
            return toGen.divide(minG);
        }
        return FloatingLong.ZERO;
    }

    public void setLevel(@NotNull Level world) {
        super.setLevel(world);
        this.isBlacklistDimension = ((List)MekanismGeneratorsConfig.generators.windGenerationDimBlacklist.get()).contains(world.dimension().location());
        if (this.isBlacklistDimension) {
            this.setActive(false);
        }
    }

    public FloatingLong getCurrentMultiplier() {
        return this.currentMultiplier;
    }

    public double getAngle() {
        return this.angle;
    }

    @ComputerMethod(nameOverride="isBlacklistedDimension")
    public boolean isBlacklistDimension() {
        return this.isBlacklistDimension;
    }

    public SoundSource getSoundCategory() {
        return SoundSource.WEATHER;
    }

    public BlockPos getSoundPos() {
        return super.getSoundPos().above(4);
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableFloatingLong.create(this::getCurrentMultiplier, value -> {
            this.currentMultiplier = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isBlacklistDimension, value -> {
            this.isBlacklistDimension = value;
        }));
    }

    @Override
    FloatingLong getProductionRate() {
        return this.getActive() ? ((FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMin.get()).multiply(this.getCurrentMultiplier()) : FloatingLong.ZERO;
    }
}

