/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntitySolarGenerator
extends TileEntityGenerator {
    private boolean seesSun;
    private FloatingLong lastProductionAmount = FloatingLong.ZERO;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy item slot")
    EnergyInventorySlot energySlot;
    @Nullable
    protected SolarCheck solarCheck;

    public TileEntitySolarGenerator(BlockPos pos, BlockState state) {
        this((IBlockProvider)GeneratorsBlocks.SOLAR_GENERATOR, pos, state, (FloatingLongSupplier)MekanismGeneratorsConfig.generators.solarGeneration);
    }

    protected TileEntitySolarGenerator(IBlockProvider blockProvider, BlockPos pos, BlockState state, @NotNull FloatingLongSupplier maxOutput) {
        super(blockProvider, pos, state, maxOutput);
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntitySolarGenerator)this).getDirection());
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    @ComputerMethod
    public boolean canSeeSun() {
        return this.seesSun;
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        if (this.solarCheck == null) {
            this.recheckSettings();
        }
        this.energySlot.drainContainer();
        this.seesSun = this.checkCanSeeSun();
        if (this.seesSun && this.canFunction() && !this.getEnergyContainer().getNeeded().isZero()) {
            this.setActive(true);
            FloatingLong production = this.getProduction();
            this.lastProductionAmount = production.subtract(this.getEnergyContainer().insert(production, Action.EXECUTE, AutomationType.INTERNAL));
        } else {
            this.setActive(false);
            this.lastProductionAmount = FloatingLong.ZERO;
        }
        return sendUpdatePacket;
    }

    protected void recheckSettings() {
        if (this.level == null) {
            return;
        }
        this.solarCheck = new SolarCheck(this.level, this.worldPosition);
        this.updateMaxOutputRaw(this.getConfiguredMax().multiply((double)this.solarCheck.getPeakMultiplier()));
    }

    protected boolean checkCanSeeSun() {
        if (this.solarCheck == null) {
            return false;
        }
        this.solarCheck.recheckCanSeeSun();
        return this.solarCheck.canSeeSun();
    }

    public FloatingLong getProduction() {
        if (this.level == null || this.solarCheck == null) {
            return FloatingLong.ZERO;
        }
        float brightness = this.getBrightnessMultiplier(this.level);
        return this.getConfiguredMax().multiply((double)(brightness * this.solarCheck.getGenerationMultiplier()));
    }

    protected float getBrightnessMultiplier(@NotNull Level world) {
        return WorldUtils.getSunBrightness((Level)world, (float)1.0f);
    }

    @Override
    protected RelativeSide[] getEnergySides() {
        return new RelativeSide[]{RelativeSide.BOTTOM};
    }

    protected FloatingLong getConfiguredMax() {
        return (FloatingLong)MekanismGeneratorsConfig.generators.solarGeneration.get();
    }

    @Override
    public FloatingLong getProductionRate() {
        return this.lastProductionAmount;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableBoolean.create(this::canSeeSun, value -> {
            this.seesSun = value;
        }));
        container.track(this.syncableMaxOutput());
        container.track((ISyncableData)SyncableFloatingLong.create(this::getProductionRate, value -> {
            this.lastProductionAmount = value;
        }));
    }

    protected static class SolarCheck {
        private final boolean needsRainCheck;
        private final float peakMultiplier;
        protected final BlockPos pos;
        protected final Level world;
        protected boolean canSeeSun;

        public SolarCheck(Level world, BlockPos pos) {
            this.world = world;
            this.pos = pos;
            Biome b = (Biome)this.world.getBiomeManager().getBiome(this.pos).value();
            this.needsRainCheck = b.getPrecipitationAt(this.pos) != Biome.Precipitation.NONE;
            float tempEff = 0.3f * (0.8f - b.getTemperature(this.pos));
            float humidityEff = this.needsRainCheck ? -0.3f * b.getModifiedClimateSettings().downfall() : 0.0f;
            this.peakMultiplier = 1.0f + tempEff + humidityEff;
        }

        public void recheckCanSeeSun() {
            this.canSeeSun = WorldUtils.canSeeSun((Level)this.world, (BlockPos)this.pos);
        }

        public boolean canSeeSun() {
            return this.canSeeSun;
        }

        public float getPeakMultiplier() {
            return this.peakMultiplier;
        }

        public float getGenerationMultiplier() {
            if (!this.canSeeSun) {
                return 0.0f;
            }
            if (this.needsRainCheck && (this.world.isRaining() || this.world.isThundering())) {
                return this.peakMultiplier * 0.2f;
            }
            return this.peakMultiplier;
        }
    }
}

