/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.listener.ConfigBasedCachedFLSupplier;
import mekanism.common.config.value.CachedValue;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.slot.FluidFuelInventorySlot;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityHeatGenerator
extends TileEntityGenerator {
    public static final double HEAT_CAPACITY = 10.0;
    public static final double INVERSE_CONDUCTION_COEFFICIENT = 5.0;
    public static final double INVERSE_INSULATION_COEFFICIENT = 100.0;
    private static final double THERMAL_EFFICIENCY = 0.5;
    private static final ConfigBasedCachedFLSupplier MAX_PRODUCTION = new ConfigBasedCachedFLSupplier(() -> {
        FloatingLong passiveMax = ((FloatingLong)MekanismGeneratorsConfig.generators.heatGenerationLava.get()).multiply((long)(EnumUtils.DIRECTIONS.length + 1));
        passiveMax = passiveMax.plusEqual((FloatingLong)MekanismGeneratorsConfig.generators.heatGenerationNether.get());
        return passiveMax.plusEqual((FloatingLong)MekanismGeneratorsConfig.generators.heatGeneration.get());
    }, new CachedValue[]{MekanismGeneratorsConfig.generators.heatGeneration, MekanismGeneratorsConfig.generators.heatGenerationLava, MekanismGeneratorsConfig.generators.heatGenerationNether});
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getLava", "getLavaCapacity", "getLavaNeeded", "getLavaFilledPercentage"}, docPlaceholder="lava tank")
    public BasicFluidTank lavaTank;
    private FloatingLong producingEnergy = FloatingLong.ZERO;
    private double lastTransferLoss;
    private double lastEnvironmentLoss;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerHeatCapacitorWrapper.class, methodNames={"getTemperature"}, docPlaceholder="generator")
    BasicHeatCapacitor heatCapacitor;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFuelItem"}, docPlaceholder="fuel item slot")
    FluidFuelInventorySlot fuelSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy item slot")
    EnergyInventorySlot energySlot;

    public TileEntityHeatGenerator(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.HEAT_GENERATOR, pos, state, (FloatingLongSupplier)MAX_PRODUCTION);
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSide(() -> ((TileEntityHeatGenerator)this).getDirection());
        this.lavaTank = VariableCapacityFluidTank.input((IntSupplier)MekanismGeneratorsConfig.generators.heatTankCapacity, fluidStack -> fluidStack.is(FluidTags.LAVA), (IContentsListener)listener);
        builder.addTank((IExtendedFluidTank)this.lavaTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityHeatGenerator)this).getDirection());
        this.fuelSlot = FluidFuelInventorySlot.forFuel((IExtendedFluidTank)this.lavaTank, stack -> stack.getBurnTime(null) / 20, size -> new FluidStack((Fluid)Fluids.LAVA, size), listener, 17, 35);
        builder.addSlot((IInventorySlot)this.fuelSlot, new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.RIGHT});
        return builder.build();
    }

    @NotNull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSide(() -> ((TileEntityHeatGenerator)this).getDirection());
        this.heatCapacitor = BasicHeatCapacitor.create((double)10.0, (double)5.0, (double)100.0, (DoubleSupplier)ambientTemperature, (IContentsListener)listener);
        builder.addCapacitor((IHeatCapacitor)this.heatCapacitor);
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.drainContainer();
        this.fuelSlot.fillOrBurn();
        FloatingLong prev = this.getEnergyContainer().getEnergy().copyAsConst();
        this.heatCapacitor.handleHeat(this.getBoost().doubleValue());
        if (this.canFunction() && !this.getEnergyContainer().getNeeded().isZero()) {
            int fluidRate = MekanismGeneratorsConfig.generators.heatGenerationFluidRate.get();
            if (this.lavaTank.extract(fluidRate, Action.SIMULATE, AutomationType.INTERNAL).getAmount() == fluidRate) {
                this.setActive(true);
                this.lavaTank.extract(fluidRate, Action.EXECUTE, AutomationType.INTERNAL);
                this.heatCapacitor.handleHeat(((FloatingLong)MekanismGeneratorsConfig.generators.heatGeneration.get()).doubleValue());
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        HeatAPI.HeatTransfer loss = this.simulate();
        this.lastTransferLoss = loss.adjacentTransfer();
        this.lastEnvironmentLoss = loss.environmentTransfer();
        this.producingEnergy = this.getEnergyContainer().getEnergy().subtract(prev);
        return sendUpdatePacket;
    }

    private FloatingLong getBoost() {
        FloatingLong boost;
        if (this.level == null) {
            return FloatingLong.ZERO;
        }
        FloatingLong passiveLavaAmount = (FloatingLong)MekanismGeneratorsConfig.generators.heatGenerationLava.get();
        if (passiveLavaAmount.isZero()) {
            boost = FloatingLong.ZERO;
        } else {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int lavaSides = 0;
            for (Direction dir : EnumUtils.DIRECTIONS) {
                mutable.setWithOffset((Vec3i)this.worldPosition, dir);
                if (!WorldUtils.getFluidState((BlockGetter)this.level, (BlockPos)mutable).filter(state -> state.is(FluidTags.LAVA)).isPresent()) continue;
                ++lavaSides;
            }
            if (this.getBlockState().getFluidState().is(FluidTags.LAVA)) {
                ++lavaSides;
            }
            boost = passiveLavaAmount.multiply((long)lavaSides);
        }
        if (this.level.dimensionType().ultraWarm()) {
            boost = boost.plusEqual((FloatingLong)MekanismGeneratorsConfig.generators.heatGenerationNether.get());
        }
        return boost;
    }

    public double getInverseInsulation(int capacitor, @Nullable Direction side) {
        return side == Direction.DOWN ? 0.0 : super.getInverseInsulation(capacitor, side);
    }

    public double getTotalInverseInsulation(@Nullable Direction side) {
        return side == Direction.DOWN ? 0.0 : super.getTotalInverseInsulation(side);
    }

    @NotNull
    public HeatAPI.HeatTransfer simulate() {
        double ambientTemp = this.ambientTemperature.getAsDouble();
        double temp = this.getTotalTemperature();
        double carnotEfficiency = 1.0 - Math.min(ambientTemp, temp) / Math.max(ambientTemp, temp);
        double heatLost = 0.5 * (temp - ambientTemp);
        this.heatCapacitor.handleHeat(-heatLost);
        FloatingLong energyFromHeat = FloatingLong.create((double)(Math.abs(heatLost) * carnotEfficiency));
        this.getEnergyContainer().insert(energyFromHeat.min((FloatingLong)MAX_PRODUCTION.get()), Action.EXECUTE, AutomationType.INTERNAL);
        return super.simulate();
    }

    @Nullable
    public IHeatHandler getAdjacent(@NotNull Direction side) {
        return side == Direction.DOWN ? this.getAdjacentUnchecked(side) : null;
    }

    @Override
    public FloatingLong getProductionRate() {
        return this.producingEnergy;
    }

    @ComputerMethod(nameOverride="getTransferLoss")
    public double getLastTransferLoss() {
        return this.lastTransferLoss;
    }

    @ComputerMethod(nameOverride="getEnvironmentalLoss")
    public double getLastEnvironmentLoss() {
        return this.lastEnvironmentLoss;
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.lavaTank.getFluidAmount(), (long)this.lavaTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.FLUID;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableFloatingLong.create(this::getProductionRate, value -> {
            this.producingEnergy = value;
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getLastTransferLoss, value -> {
            this.lastTransferLoss = value;
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getLastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
    }
}

