/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.energy.BlockEnergyCapabilityCache;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.CableUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityGenerator
extends TileEntityMekanism {
    @Nullable
    private List<BlockEnergyCapabilityCache> outputCaches;
    private FloatingLong maxOutput;
    private BasicEnergyContainer energyContainer;

    public TileEntityGenerator(IBlockProvider blockProvider, BlockPos pos, BlockState state, @NotNull FloatingLongSupplier maxOutput) {
        super(blockProvider, pos, state);
        this.updateMaxOutputRaw(maxOutput.get());
    }

    protected RelativeSide[] getEnergySides() {
        return new RelativeSide[]{RelativeSide.FRONT};
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(() -> ((TileEntityGenerator)this).getDirection());
        this.energyContainer = BasicEnergyContainer.output((FloatingLong)MachineEnergyContainer.validateBlock((TileEntityMekanism)this).getStorage(), (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer, this.getEnergySides());
        return builder.build();
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        if (this.canFunction()) {
            if (this.outputCaches == null) {
                Direction direction = this.getDirection();
                RelativeSide[] energySides = this.getEnergySides();
                this.outputCaches = new ArrayList<BlockEnergyCapabilityCache>(energySides.length);
                for (RelativeSide energySide : this.getEnergySides()) {
                    Direction side = energySide.getDirection(direction);
                    this.outputCaches.add(BlockEnergyCapabilityCache.create((ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition.relative(side), (Direction)side.getOpposite()));
                }
            }
            CableUtils.emit(this.outputCaches, (IEnergyContainer)this.energyContainer, (FloatingLong)this.getMaxOutput());
        }
        return sendUpdatePacket;
    }

    protected void invalidateDirectionCaches(Direction newDirection) {
        super.invalidateDirectionCaches(newDirection);
        this.outputCaches = null;
    }

    @ComputerMethod
    public FloatingLong getMaxOutput() {
        return this.maxOutput;
    }

    protected void updateMaxOutputRaw(FloatingLong maxOutput) {
        this.maxOutput = maxOutput.multiply(2L);
    }

    protected ISyncableData syncableMaxOutput() {
        return SyncableFloatingLong.create(this::getMaxOutput, value -> {
            this.maxOutput = value;
        });
    }

    public BasicEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod(methodDescription="Get the amount of energy produced by this generator in the last tick.")
    abstract FloatingLong getProductionRate();
}

