/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import mekanism.api.text.ILangEntry;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlockTypes;
import mekanism.generators.common.tile.turbine.TileEntityElectromagneticCoil;
import mekanism.generators.common.tile.turbine.TileEntityRotationalComplex;
import mekanism.generators.common.tile.turbine.TileEntitySaturatingCondenser;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import mekanism.generators.common.tile.turbine.TileEntityTurbineVent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class TurbineValidator
extends CuboidStructureValidator<TurbineMultiblockData> {
    public static final int MAX_BLADES = 28;

    public TurbineValidator() {
        super(new VoxelCuboid(5, 3, 5), new VoxelCuboid(17, 18, 17));
    }

    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.getBlock();
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.TURBINE_CASING})) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.TURBINE_VALVE})) {
            return FormationProtocol.CasingType.VALVE;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.TURBINE_VENT})) {
            return FormationProtocol.CasingType.OTHER;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    protected boolean validateInner(BlockState state, Long2ObjectMap<ChunkAccess> chunkMap, BlockPos pos) {
        if (super.validateInner(state, chunkMap, pos)) {
            return true;
        }
        return BlockType.is((Block)state.getBlock(), (BlockType[])new BlockType[]{MekanismBlockTypes.PRESSURE_DISPERSER, GeneratorsBlockTypes.TURBINE_ROTOR, GeneratorsBlockTypes.ROTATIONAL_COMPLEX, GeneratorsBlockTypes.ELECTROMAGNETIC_COIL, GeneratorsBlockTypes.SATURATING_CONDENSER});
    }

    public FormationProtocol.FormationResult postcheck(TurbineMultiblockData structure, Long2ObjectMap<ChunkAccess> chunkMap) {
        if (structure.length() % 2 != 1 || structure.width() % 2 != 1) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_EVEN_LENGTH);
        }
        int centerX = structure.getMinPos().getX() + (structure.length() - 1) / 2;
        int centerZ = structure.getMinPos().getZ() + (structure.width() - 1) / 2;
        BlockPos complex = null;
        ObjectOpenHashSet turbines = new ObjectOpenHashSet();
        ObjectOpenHashSet dispersers = new ObjectOpenHashSet();
        ObjectOpenHashSet coils = new ObjectOpenHashSet();
        ObjectOpenHashSet condensers = new ObjectOpenHashSet();
        for (BlockPos pos2 : structure.internalLocations) {
            BlockEntity tile = WorldUtils.getTileEntity((LevelAccessor)this.world, chunkMap, (BlockPos)pos2);
            if (tile instanceof TileEntityRotationalComplex) {
                if (complex != null || pos2.getX() != centerX || pos2.getZ() != centerZ) {
                    return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_BAD_COMPLEX, (BlockPos)pos2);
                }
                complex = pos2;
                continue;
            }
            if (tile instanceof TileEntityTurbineRotor) {
                if (pos2.getX() != centerX || pos2.getZ() != centerZ) {
                    return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_BAD_ROTOR, (BlockPos)pos2);
                }
                turbines.add(pos2);
                continue;
            }
            if (tile instanceof TileEntityPressureDisperser) {
                dispersers.add(pos2);
                continue;
            }
            if (tile instanceof TileEntityElectromagneticCoil) {
                coils.add(pos2);
                continue;
            }
            if (!(tile instanceof TileEntitySaturatingCondenser)) continue;
            condensers.add(pos2);
        }
        if (complex == null) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_MISSING_COMPLEX);
        }
        int rotors = complex.getY() - structure.getMinPos().getY() + 1;
        int innerRadius = (Math.min(structure.length(), structure.width()) - 3) / 2;
        if (innerRadius < rotors / 4) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_TOO_NARROW);
        }
        if (coils.isEmpty()) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_MISSING_COILS);
        }
        if (dispersers.isEmpty()) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_MISSING_DISPERSERS);
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = complex.getX() - innerRadius; x <= complex.getX() + innerRadius; ++x) {
            for (int z = complex.getZ() - innerRadius; z <= complex.getZ() + innerRadius; ++z) {
                if (x == centerX && z == centerZ) continue;
                mutablePos.set(x, complex.getY(), z);
                TileEntityPressureDisperser tile = (TileEntityPressureDisperser)WorldUtils.getTileEntity(TileEntityPressureDisperser.class, (LevelAccessor)this.world, chunkMap, (BlockPos)mutablePos);
                if (tile == null) {
                    return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_MISSING_DISPERSER, (BlockPos)mutablePos);
                }
                dispersers.remove(mutablePos);
            }
        }
        if (!dispersers.isEmpty()) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_MALFORMED_DISPERSERS);
        }
        for (BlockPos coord : condensers) {
            if (coord.getY() > complex.getY()) continue;
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_CONDENSER_BELOW_COMPLEX, (BlockPos)coord);
        }
        structure.condensers = condensers.size();
        int turbineHeight = 0;
        int blades = 0;
        for (int y = complex.getY() - 1; y > structure.getMinPos().getY(); --y) {
            mutablePos.set(centerX, y, centerZ);
            TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)WorldUtils.getTileEntity(TileEntityTurbineRotor.class, (LevelAccessor)this.world, chunkMap, (BlockPos)mutablePos);
            if (rotor == null) {
                return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_ROTORS_NOT_CONTIGUOUS);
            }
            ++turbineHeight;
            blades += rotor.getHousedBlades();
            turbines.remove(mutablePos);
        }
        if (!turbines.isEmpty()) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_BAD_ROTORS);
        }
        if (blades == 0) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_NO_BLADES);
        }
        structure.blades = blades;
        structure.coils = FormationProtocol.explore((Level)this.world, chunkMap, (BlockPos)complex.relative(Direction.UP), null, (level, chunks, start, n, pos) -> WorldUtils.getTileEntity(TileEntityElectromagneticCoil.class, (LevelAccessor)level, (Long2ObjectMap)chunks, (BlockPos)pos) != null);
        if (coils.size() > structure.coils) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_MALFORMED_COILS);
        }
        ArrayList<TurbineMultiblockData.VentData> ventData = new ArrayList<TurbineMultiblockData.VentData>();
        for (BlockPos coord : structure.locations) {
            if (WorldUtils.getTileEntity(TileEntityTurbineVent.class, (LevelAccessor)this.world, chunkMap, (BlockPos)coord) == null) continue;
            if (coord.getY() < complex.getY()) {
                return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_VENT_BELOW_COMPLEX, (BlockPos)coord);
            }
            ventData.add(new TurbineMultiblockData.VentData(coord, this.getSide(coord)));
        }
        if (ventData.isEmpty()) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_MISSING_VENTS);
        }
        structure.updateVentData(ventData);
        structure.lowerVolume = structure.length() * structure.width() * turbineHeight;
        structure.complex = complex;
        return FormationProtocol.FormationResult.SUCCESS;
    }
}

