/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.gear.mekasuit;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

@ParametersAreNotNullByDefault
public class ModuleSolarRechargingUnit
implements ICustomModule<ModuleSolarRechargingUnit> {
    private static final FloatingLong RAIN_MULTIPLIER = FloatingLong.createConst((double)0.2);

    public void tickServer(IModule<ModuleSolarRechargingUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player) {
        IEnergyContainer energyContainer = module.getEnergyContainer(stack);
        if (energyContainer != null && !energyContainer.getNeeded().isZero()) {
            BlockPos pos = BlockPos.containing((double)player.getX(), (double)(player.getEyeY() + 0.2), (double)player.getZ());
            if (WorldUtils.canSeeSun((Level)player.level(), (BlockPos)pos)) {
                Biome b = (Biome)player.level().getBiomeManager().getBiome(pos).value();
                boolean needsRainCheck = b.getPrecipitationAt(pos) != Biome.Precipitation.NONE;
                float tempEff = 0.3f * (0.8f - b.getTemperature(pos));
                float humidityEff = needsRainCheck ? -0.3f * b.getModifiedClimateSettings().downfall() : 0.0f;
                FloatingLong peakOutput = ((FloatingLong)MekanismConfig.gear.mekaSuitSolarRechargingRate.get()).multiply((double)(1.0f + tempEff + humidityEff));
                float brightness = WorldUtils.getSunBrightness((Level)player.level(), (float)1.0f);
                FloatingLong production = peakOutput.multiply((double)brightness);
                if (needsRainCheck && (player.level().isRaining() || player.level().isThundering())) {
                    production = production.timesEqual(RAIN_MULTIPLIER);
                }
                energyContainer.insert(production.multiply((long)module.getInstalledCount()), Action.EXECUTE, AutomationType.MANUAL);
            }
        }
    }
}

