/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.fusion;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.math.MathUtils;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.capabilities.energy.VariableCapacityEnergyContainer;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.capabilities.heat.VariableHeatCapacitor;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tile.prefab.TileEntityStructuralMultiblock;
import mekanism.common.util.CableUtils;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.GeneratorTags;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.item.ItemHohlraum;
import mekanism.generators.common.registries.GeneratorsGases;
import mekanism.generators.common.slot.ReactorInventorySlot;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorPort;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class FusionReactorMultiblockData
extends MultiblockData {
    public static final String HEAT_TAB = "heat";
    public static final String FUEL_TAB = "fuel";
    public static final String STATS_TAB = "stats";
    public static final int MAX_INJECTION = 98;
    private static final double burnTemperature = 1.0E8;
    private static final double burnRatio = 1.0;
    private static final double plasmaHeatCapacity = 100.0;
    private static final double caseHeatCapacity = 1.0;
    private static final double inverseInsulation = 100000.0;
    private static final double plasmaCaseConductivity = 0.2;
    private final List<MultiblockData.EnergyOutputTarget> energyOutputTargets = new ArrayList<MultiblockData.EnergyOutputTarget>();
    private final List<MultiblockData.CapabilityOutputTarget<IGasHandler>> gasOutputTargets = new ArrayList<MultiblockData.CapabilityOutputTarget<IGasHandler>>();
    private final Set<ITileHeatHandler> heatHandlers = new ObjectOpenHashSet();
    @ContainerSync
    private boolean burning = false;
    @ContainerSync
    public IEnergyContainer energyContainer;
    public IHeatCapacitor heatCapacitor;
    @ContainerSync(tags={"heat"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getWater", "getWaterCapacity", "getWaterNeeded", "getWaterFilledPercentage"}, docPlaceholder="water tank")
    public IExtendedFluidTank waterTank;
    @ContainerSync(tags={"heat"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getSteam", "getSteamCapacity", "getSteamNeeded", "getSteamFilledPercentage"}, docPlaceholder="steam tank")
    public IGasTank steamTank;
    private double biomeAmbientTemp;
    @ContainerSync(tags={"heat"})
    private double lastPlasmaTemperature;
    @ContainerSync
    private double lastCaseTemperature;
    @ContainerSync
    @SyntheticComputerMethod(getter="getEnvironmentalLoss")
    public double lastEnvironmentLoss;
    @ContainerSync
    @SyntheticComputerMethod(getter="getTransferLoss")
    public double lastTransferLoss;
    @ContainerSync(tags={"fuel"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getDeuterium", "getDeuteriumCapacity", "getDeuteriumNeeded", "getDeuteriumFilledPercentage"}, docPlaceholder="deuterium tank")
    public IGasTank deuteriumTank;
    @ContainerSync(tags={"fuel"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getTritium", "getTritiumCapacity", "getTritiumNeeded", "getTritiumFilledPercentage"}, docPlaceholder="tritium tank")
    public IGasTank tritiumTank;
    @ContainerSync(tags={"fuel"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getDTFuel", "getDTFuelCapacity", "getDTFuelNeeded", "getDTFuelFilledPercentage"}, docPlaceholder="fuel tank")
    public IGasTank fuelTank;
    @ContainerSync(tags={"fuel", "heat", "stats"}, getter="getInjectionRate", setter="setInjectionRate")
    private int injectionRate = 2;
    @ContainerSync(tags={"fuel", "heat", "stats"})
    private long lastBurned;
    public double plasmaTemperature;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getHohlraum"}, docPlaceholder="Hohlraum slot")
    final ReactorInventorySlot reactorSlot;
    private boolean clientBurning;
    private double clientTemp;
    private int maxWater;
    private long maxSteam;
    private AABB deathZone;

    public FusionReactorMultiblockData(TileEntityFusionReactorBlock tile) {
        super((BlockEntity)tile);
        this.lastPlasmaTemperature = this.biomeAmbientTemp = HeatAPI.getAmbientTemp((LevelReader)tile.getLevel(), (BlockPos)tile.getBlockPos());
        this.lastCaseTemperature = this.biomeAmbientTemp;
        this.plasmaTemperature = this.biomeAmbientTemp;
        this.deuteriumTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.input((MultiblockData)this, (LongSupplier)MekanismGeneratorsConfig.generators.fusionFuelCapacity, gas -> gas.is(GeneratorTags.Gases.DEUTERIUM), (IContentsListener)this);
        this.gasTanks.add(this.deuteriumTank);
        this.tritiumTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.input((MultiblockData)this, (LongSupplier)MekanismGeneratorsConfig.generators.fusionFuelCapacity, gas -> gas.is(GeneratorTags.Gases.TRITIUM), (IContentsListener)this);
        this.gasTanks.add(this.tritiumTank);
        this.fuelTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.input((MultiblockData)this, (LongSupplier)MekanismGeneratorsConfig.generators.fusionFuelCapacity, gas -> gas.is(GeneratorTags.Gases.FUSION_FUEL), this.createSaveAndComparator());
        this.gasTanks.add(this.fuelTank);
        this.steamTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.output((MultiblockData)this, this::getMaxSteam, gas -> gas == MekanismGases.STEAM.getChemical(), (IContentsListener)this);
        this.gasTanks.add(this.steamTank);
        this.waterTank = VariableCapacityFluidTank.input((MultiblockData)this, this::getMaxWater, fluid -> fluid.is(FluidTags.WATER), (IContentsListener)this);
        this.fluidTanks.add(this.waterTank);
        this.energyContainer = VariableCapacityEnergyContainer.output((FloatingLongSupplier)MekanismGeneratorsConfig.generators.fusionEnergyCapacity, (IContentsListener)this);
        this.energyContainers.add(this.energyContainer);
        this.heatCapacitor = VariableHeatCapacitor.create((double)1.0, FusionReactorMultiblockData::getInverseConductionCoefficient, () -> 100000.0, () -> this.biomeAmbientTemp, (IContentsListener)this);
        this.heatCapacitors.add(this.heatCapacitor);
        this.reactorSlot = ReactorInventorySlot.at(stack -> stack.getItem() instanceof ItemHohlraum, (IContentsListener)this, 80, 39);
        this.inventorySlots.add(this.reactorSlot);
    }

    public void onCreated(Level world) {
        super.onCreated(world);
        for (IValveHandler.ValveData data : this.valves) {
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, (BlockPos)data.location);
            if (!(tile instanceof TileEntityFusionReactorPort)) continue;
            TileEntityFusionReactorPort port = (TileEntityFusionReactorPort)tile;
            this.heatHandlers.add((ITileHeatHandler)port);
        }
        this.biomeAmbientTemp = this.calculateAverageAmbientTemperature(world);
        this.deathZone = AABB.encapsulatingFullBlocks((BlockPos)this.getMinPos().offset(1, 1, 1), (BlockPos)this.getMaxPos().offset(-1, -1, -1));
    }

    public boolean allowsStructuralGuiAccess(TileEntityStructuralMultiblock multiblock) {
        return false;
    }

    public void readUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.readUpdateTag(tag, provider);
        NBTUtils.setDoubleIfPresent((CompoundTag)tag, (String)"plasma_temp", this::setLastPlasmaTemp);
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"burning", this::setBurning);
    }

    public void writeUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeUpdateTag(tag, provider);
        tag.putDouble("plasma_temp", this.getLastPlasmaTemp());
        tag.putBoolean("burning", this.isBurning());
    }

    public void addTemperatureFromEnergyInput(FloatingLong energyAdded) {
        if (this.isBurning()) {
            this.setPlasmaTemp(this.getPlasmaTemp() + energyAdded.divide(100.0).doubleValue());
        } else {
            this.setPlasmaTemp(this.getPlasmaTemp() + energyAdded.divide(100.0).multiply(10L).doubleValue());
        }
    }

    private boolean hasHohlraum() {
        IGasHandler gasHandlerItem;
        ItemStack hohlraum;
        if (!this.reactorSlot.isEmpty() && (hohlraum = this.reactorSlot.getStack()).getItem() instanceof ItemHohlraum && (gasHandlerItem = (IGasHandler)Capabilities.GAS.getCapability(hohlraum)) != null && gasHandlerItem.getTanks() > 0) {
            return ((GasStack)gasHandlerItem.getChemicalInTank(0)).getAmount() == gasHandlerItem.getTankCapacity(0);
        }
        return false;
    }

    public boolean tick(Level world) {
        boolean needsPacket = super.tick(world);
        long fuelBurned = 0L;
        if (this.getPlasmaTemp() >= 1.0E8) {
            if (!this.burning && this.hasHohlraum()) {
                this.vaporiseHohlraum();
            }
            if (this.isBurning()) {
                this.injectFuel();
                fuelBurned = this.burnFuel();
                if (fuelBurned == 0L) {
                    this.setBurning(false);
                }
            }
        } else {
            this.setBurning(false);
        }
        if (this.lastBurned != fuelBurned) {
            this.lastBurned = fuelBurned;
        }
        this.transferHeat();
        this.updateHeatCapacitors(null);
        this.updateTemperatures();
        if (!this.energyOutputTargets.isEmpty() && !this.energyContainer.isEmpty()) {
            CableUtils.emit((Collection)this.getActiveOutputs(this.energyOutputTargets), (IEnergyContainer)this.energyContainer);
        }
        if (!this.gasOutputTargets.isEmpty() && !this.steamTank.isEmpty()) {
            ChemicalUtil.emit((Collection)this.getActiveOutputs(this.gasOutputTargets), (IChemicalTank)this.steamTank);
        }
        if (this.isBurning()) {
            this.kill(world);
        }
        if (this.isBurning() != this.clientBurning || Math.abs(this.getLastPlasmaTemp() - this.clientTemp) > 1000000.0) {
            this.clientBurning = this.isBurning();
            this.clientTemp = this.getLastPlasmaTemp();
            needsPacket = true;
        }
        return needsPacket;
    }

    protected void updateEjectors(Level world) {
        this.energyOutputTargets.clear();
        this.gasOutputTargets.clear();
        for (IValveHandler.ValveData valve : this.valves) {
            TileEntityFusionReactorPort tile = (TileEntityFusionReactorPort)WorldUtils.getTileEntity(TileEntityFusionReactorPort.class, (BlockGetter)world, (BlockPos)valve.location);
            if (tile == null) continue;
            tile.addEnergyTargetCapability(this.energyOutputTargets, valve.side);
            tile.addGasTargetCapability(this.gasOutputTargets, valve.side);
        }
    }

    public void updateTemperatures() {
        this.lastPlasmaTemperature = this.getPlasmaTemp();
        this.lastCaseTemperature = this.heatCapacitor.getTemperature();
    }

    private void kill(Level world) {
        if (world.getRandom().nextInt() % 20 != 0) {
            return;
        }
        List entitiesToDie = this.getLevel().getEntitiesOfClass(Entity.class, this.deathZone);
        for (Entity entity : entitiesToDie) {
            entity.hurt(entity.damageSources().magic(), 50000.0f);
        }
    }

    private void vaporiseHohlraum() {
        ItemStack hohlraum = this.reactorSlot.getStack();
        IGasHandler gasHandlerItem = (IGasHandler)Capabilities.GAS.getCapability(hohlraum);
        if (gasHandlerItem != null && gasHandlerItem.getTanks() > 0) {
            this.fuelTank.insert((ChemicalStack)((GasStack)gasHandlerItem.getChemicalInTank(0)), Action.EXECUTE, AutomationType.INTERNAL);
            this.lastPlasmaTemperature = this.getPlasmaTemp();
            this.reactorSlot.setEmpty();
            this.setBurning(true);
        }
    }

    private void injectFuel() {
        long amountNeeded = this.fuelTank.getNeeded();
        long amountAvailable = 2L * Math.min(this.deuteriumTank.getStored(), this.tritiumTank.getStored());
        long amountToInject = Math.min(amountNeeded, Math.min(amountAvailable, (long)this.injectionRate));
        amountToInject -= amountToInject % 2L;
        long injectingAmount = amountToInject / 2L;
        MekanismUtils.logMismatchedStackSize((long)this.deuteriumTank.shrinkStack(injectingAmount, Action.EXECUTE), (long)injectingAmount);
        MekanismUtils.logMismatchedStackSize((long)this.tritiumTank.shrinkStack(injectingAmount, Action.EXECUTE), (long)injectingAmount);
        this.fuelTank.insert((ChemicalStack)GeneratorsGases.FUSION_FUEL.getStack(amountToInject), Action.EXECUTE, AutomationType.INTERNAL);
    }

    private long burnFuel() {
        long fuelBurned = MathUtils.clampToLong((double)Mth.clamp((double)((this.lastPlasmaTemperature - 1.0E8) * 1.0), (double)0.0, (double)this.fuelTank.getStored()));
        MekanismUtils.logMismatchedStackSize((long)this.fuelTank.shrinkStack(fuelBurned, Action.EXECUTE), (long)fuelBurned);
        this.setPlasmaTemp(this.getPlasmaTemp() + ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).multiply(fuelBurned).divide(100.0).doubleValue());
        return fuelBurned;
    }

    private void transferHeat() {
        double caseWaterHeat;
        double plasmaCaseHeat = 0.2 * (this.lastPlasmaTemperature - this.lastCaseTemperature);
        if (Math.abs(plasmaCaseHeat) > (double)1.0E-6f) {
            this.setPlasmaTemp(this.getPlasmaTemp() - plasmaCaseHeat / 100.0);
            this.heatCapacitor.handleHeat(plasmaCaseHeat);
        }
        if (Math.abs(caseWaterHeat = MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get() * (this.lastCaseTemperature - this.biomeAmbientTemp)) > (double)1.0E-6f) {
            int waterToVaporize = (int)(HeatUtils.getSteamEnergyEfficiency() * caseWaterHeat / HeatUtils.getWaterThermalEnthalpy());
            if ((waterToVaporize = Math.min(waterToVaporize, Math.min(this.waterTank.getFluidAmount(), MathUtils.clampToInt((long)this.steamTank.getNeeded())))) > 0) {
                MekanismUtils.logMismatchedStackSize((long)this.waterTank.shrinkStack(waterToVaporize, Action.EXECUTE), (long)waterToVaporize);
                this.steamTank.insert((ChemicalStack)MekanismGases.STEAM.getStack((long)waterToVaporize), Action.EXECUTE, AutomationType.INTERNAL);
                caseWaterHeat = (double)waterToVaporize * HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency();
                this.heatCapacitor.handleHeat(-caseWaterHeat);
            }
        }
        HeatAPI.HeatTransfer heatTransfer = this.simulate();
        this.lastEnvironmentLoss = heatTransfer.environmentTransfer();
        this.lastTransferLoss = heatTransfer.adjacentTransfer();
        double caseAirHeat = MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get() * (this.lastCaseTemperature - this.biomeAmbientTemp);
        if (Math.abs(caseAirHeat) > (double)1.0E-6f) {
            this.heatCapacitor.handleHeat(-caseAirHeat);
            this.energyContainer.insert(FloatingLong.create((double)(caseAirHeat * MekanismGeneratorsConfig.generators.fusionThermocoupleEfficiency.get())), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    @NotNull
    public HeatAPI.HeatTransfer simulate() {
        double environmentTransfer = 0.0;
        double adjacentTransfer = 0.0;
        for (ITileHeatHandler source : this.heatHandlers) {
            HeatAPI.HeatTransfer heatTransfer = source.simulate();
            adjacentTransfer += heatTransfer.adjacentTransfer();
            environmentTransfer += heatTransfer.environmentTransfer();
        }
        return new HeatAPI.HeatTransfer(adjacentTransfer, environmentTransfer);
    }

    public void setLastPlasmaTemp(double temp) {
        this.lastPlasmaTemperature = temp;
    }

    @ComputerMethod(nameOverride="getPlasmaTemperature")
    public double getLastPlasmaTemp() {
        return this.lastPlasmaTemperature;
    }

    @ComputerMethod(nameOverride="getCaseTemperature")
    public double getLastCaseTemp() {
        return this.lastCaseTemperature;
    }

    public double getPlasmaTemp() {
        return this.plasmaTemperature;
    }

    public void setPlasmaTemp(double temp) {
        if (this.plasmaTemperature != temp) {
            this.plasmaTemperature = temp;
            this.markDirty();
        }
    }

    @ComputerMethod
    public int getInjectionRate() {
        return this.injectionRate;
    }

    public void setInjectionRate(int rate) {
        if (this.injectionRate != rate) {
            this.injectionRate = rate;
            this.maxWater = this.injectionRate * MekanismGeneratorsConfig.generators.fusionWaterPerInjection.get();
            this.maxSteam = (long)this.injectionRate * MekanismGeneratorsConfig.generators.fusionSteamPerInjection.get();
            if (this.getLevel() != null && !this.isRemote()) {
                if (!this.waterTank.isEmpty()) {
                    this.waterTank.setStackSize(Math.min(this.waterTank.getFluidAmount(), this.waterTank.getCapacity()), Action.EXECUTE);
                }
                if (!this.steamTank.isEmpty()) {
                    this.steamTank.setStackSize(Math.min(this.steamTank.getStored(), this.steamTank.getCapacity()), Action.EXECUTE);
                }
            }
            this.markDirty();
        }
    }

    public int getMaxWater() {
        return this.maxWater;
    }

    public long getMaxSteam() {
        return this.maxSteam;
    }

    @ComputerMethod(nameOverride="isIgnited", methodDescription="Checks if a reaction is occurring.")
    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean burn) {
        if (this.burning != burn) {
            this.burning = burn;
            this.markDirty();
        }
    }

    public double getCaseTemp() {
        return this.heatCapacitor.getTemperature();
    }

    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fuelTank.getStored(), (long)this.fuelTank.getCapacity());
    }

    @ComputerMethod(methodDescription="true -> water cooled, false -> air cooled")
    public int getMinInjectionRate(boolean active) {
        double k = active ? MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get() : 0.0;
        double caseAirConductivity = MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get();
        double aMin = 2.0E7 * (k + caseAirConductivity) / (((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).doubleValue() * 1.0 * (0.2 + k + caseAirConductivity) - 0.2 * (k + caseAirConductivity));
        return 2 * Mth.ceil((double)(aMin / 2.0));
    }

    @ComputerMethod(methodDescription="true -> water cooled, false -> air cooled")
    public double getMaxPlasmaTemperature(boolean active) {
        double k = active ? MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get() : 0.0;
        double caseAirConductivity = MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get();
        long injectionRate = Math.max((long)this.injectionRate, this.lastBurned);
        return (double)injectionRate * ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).doubleValue() / 0.2 * (0.2 + k + caseAirConductivity) / (k + caseAirConductivity);
    }

    @ComputerMethod(methodDescription="true -> water cooled, false -> air cooled")
    public double getMaxCasingTemperature(boolean active) {
        double k = active ? MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get() : 0.0;
        long injectionRate = Math.max((long)this.injectionRate, this.lastBurned);
        return ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).multiply(injectionRate).divide(k + MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get()).doubleValue();
    }

    @ComputerMethod(methodDescription="true -> water cooled, false -> air cooled")
    public double getIgnitionTemperature(boolean active) {
        double k = active ? MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get() : 0.0;
        double caseAirConductivity = MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get();
        double energyPerFusionFuel = ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).doubleValue();
        return 1.0E8 * energyPerFusionFuel * 1.0 * (0.2 + k + caseAirConductivity) / (energyPerFusionFuel * 1.0 * (0.2 + k + caseAirConductivity) - 0.2 * (k + caseAirConductivity));
    }

    public FloatingLong getPassiveGeneration(boolean active, boolean current) {
        double temperature = current ? this.getLastCaseTemp() : this.getMaxCasingTemperature(active);
        return FloatingLong.create((double)(MekanismGeneratorsConfig.generators.fusionThermocoupleEfficiency.get() * MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get() * temperature));
    }

    public long getSteamPerTick(boolean current) {
        double temperature = current ? this.getLastCaseTemp() : this.getMaxCasingTemperature(true);
        return MathUtils.clampToLong((double)(HeatUtils.getSteamEnergyEfficiency() * MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get() * temperature / HeatUtils.getWaterThermalEnthalpy()));
    }

    private static double getInverseConductionCoefficient() {
        return 1.0 / MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get();
    }

    @ComputerMethod(nameOverride="setInjectionRate")
    void computerSetInjectionRate(int rate) throws ComputerException {
        if (rate < 0 || rate > 98) {
            throw new ComputerException("Injection Rate '%d' is out of range must be an even number between 0 and %d. (Inclusive)", new Object[]{rate, 98});
        }
        if (rate % 2 != 0) {
            throw new ComputerException("Injection Rate '%d' must be an even number between 0 and %d. (Inclusive)", new Object[]{rate, 98});
        }
        this.setInjectionRate(rate);
    }

    @ComputerMethod
    FloatingLong getPassiveGeneration(boolean active) {
        return this.getPassiveGeneration(active, false);
    }

    @ComputerMethod
    FloatingLong getProductionRate() {
        return this.getPassiveGeneration(false, true);
    }
}

