/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.List;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.tile.TileEntityGasGenerator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiGasGenerator
extends GuiMekanismTile<TileEntityGasGenerator, MekanismTileContainer<TileEntityGasGenerator>> {
    public GuiGasGenerator(MekanismTileContainer<TileEntityGasGenerator> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiEnergyTab((IGuiWrapper)this, () -> List.of(GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{EnergyDisplay.of((FloatingLong)((TileEntityGasGenerator)this.tile).getGenerationRate().multiply(((TileEntityGasGenerator)this.tile).getUsed()).multiply((long)((TileEntityGasGenerator)this.tile).getMaxBurnTicks()))}), MekanismLang.MAX_OUTPUT.translate(new Object[]{EnergyDisplay.of((FloatingLong)((TileEntityGasGenerator)this.tile).getMaxOutput())}))));
        this.addRenderableWidget((GuiElement)new GuiGasGauge(() -> ((TileEntityGasGenerator)this.tile).fuelTank, () -> ((TileEntityGasGenerator)this.tile).getGasTanks(null), GaugeType.WIDE, (IGuiWrapper)this, 55, 18));
        this.addRenderableWidget((GuiElement)new GuiVerticalPowerBar((IGuiWrapper)this, (IEnergyContainer)((TileEntityGasGenerator)this.tile).getEnergyContainer(), 164, 15));
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        MutableComponent component = GeneratorsLang.GAS_BURN_RATE.translate(new Object[]{((TileEntityGasGenerator)this.tile).getUsed()});
        int left = this.inventoryLabelX + this.getStringWidth(this.playerInventoryTitle) + 4;
        int end = this.imageWidth - 8;
        left = Math.max(left, end - this.getStringWidth((Component)component));
        this.drawTextScaledBound(guiGraphics, (Component)component, left, this.inventoryLabelY, this.titleTextColor(), end - left);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

